#include <qwt_plot.h>
#include <qwt_plot_dict.h>
#include "realtimeplot.h"

RealtimeCurveData::RealtimeCurveData():
	_count(4000)
{
}

void RealtimeCurveData::append(double *x, double *y, int count)
{
   int newSize = ( (_count + count) / 60000 + 1 ) * 60000;

  if ( newSize > size() )
	{
		_x.resize(newSize);
		_y.resize(newSize);
	}

	for ( register int i = 0; i < count; i++ )
	{
		_x[_count + i] = x[i];
		_y[_count + i] = y[i];
	}
	_count += count;
}

int RealtimeCurveData::count() const
{
	return _count;
}

int RealtimeCurveData::size() const
{
	return _x.size();
}

double *RealtimeCurveData::X() const
{
	return _x.data();
}

double *RealtimeCurveData::Y() const
{
	return _y.data();
}

RealtimePlot::RealtimePlot(QWidget *parent, const char* name): 
	IncrementalPlot(parent, name)
{
	_curveDictionary.setAutoDelete(TRUE);
}

RealtimePlot::~RealtimePlot()
{
	removeCurves();
}

void RealtimePlot::appendCurveData(long curveId, 
	double *x, double *y, int size)
{
    QwtPlotCurve *curve = RealtimePlot::curve(curveId);
	if ( curve == 0 || size <= 0 )
		return;
	
	RealtimeCurveData *curveData = _curveDictionary.find(curveId);
	if ( curveData == 0 )
	{
		curveData = new RealtimeCurveData();
		_curveDictionary.insert(curveId, curveData);
	}

	curveData->append(x, y, size);
	curve->setRawData(curveData->X(), curveData->Y(), curveData->count());

	drawCurveIntervall(curveId, 
		curve->dataSize() - size, curve->dataSize() - 1);

}

void RealtimePlot::removeCurveData(long curveId)
{
	_curveDictionary.remove(curveId);
}
