#include <stdio.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qstatusbar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qsocket.h>
#include <qmessagebox.h>
#include "brhwidget.h"
#include "mainwindow.h"
#include "start.xpm"
#include "clear.xpm"

extern char hostname[];
class MyToolBar: public QToolBar
{
public:
	MyToolBar(MainWindow *);
	void addSpacing(int);
	void addStretch();
};

MyToolBar::MyToolBar(MainWindow *parent):
	QToolBar(parent)
{
}

void MyToolBar::addSpacing(int spacing)
{
    QLabel *label = new QLabel(this);
    label->setFixedWidth(spacing);
}

void MyToolBar::addStretch()
{
    QLabel *label = new QLabel(this);
	setStretchableWidget(label);
}

MainWindow::MainWindow()
{
    setDockEnabled(TornOff, TRUE);
    setRightJustification(TRUE);

	(void)toolBar();
	(void)statusBar();



	brh_widget = new BRHWidgetWindow(this);

       	setCentralWidget(brh_widget);
	

	connect(_startBtn, SIGNAL(toggled(bool)), this, SLOT(connectBRH(bool)));
	initWhatsThis();

}

QToolBar *MainWindow::toolBar()
{
	MyToolBar *toolBar = new MyToolBar(this);

	_startBtn = new QToolButton(toolBar);
	_startBtn->setUsesTextLabel(TRUE);
	_startBtn->setPixmap(QPixmap(start_xpm));
	_startBtn->setToggleButton(TRUE);


	QToolButton *helpBtn = QWhatsThis::whatsThisButton(toolBar);
	helpBtn->setUsesTextLabel(TRUE);
	helpBtn->setTextLabel("Help", FALSE);

	toolBar->addSpacing(20);
	toolBar->addStretch();


	showRunning(FALSE);

	_startBtn->setMinimumWidth(helpBtn->sizeHint().width() + 20);
	helpBtn->setMinimumWidth(helpBtn->sizeHint().width() + 20);

	return toolBar;
}

void MainWindow::connectBRH(bool on)
{
  
  if ( on ) {
    // connect to BRH board

    socket = new QSocket( this );
    connect( socket, SIGNAL(connected()),
	     SLOT(socketConnected()) );
    connect( socket, SIGNAL(connectionClosed()),
	     SLOT(socketConnectionClosed()) );
    connect( socket, SIGNAL(readyRead()),
	     SLOT(socketReadyRead()) );
    connect( socket, SIGNAL(error(int)),
	     SLOT(socketError(int)) );

    socket->connectToHost(hostname, 15000 );
    printf("Trying to connect to %s at port 15000 \n", hostname);
   
  } else {

    // close connection
    
    socket->close();
    // We have a delayed close.
    if (socket->state() == QSocket::Closing) {
      connect( socket, SIGNAL(delayedCloseFinished()),
	       SLOT(socketClosed()) );
    } else {
      // The socket is closed.
      socketConnectionClosed();
    }
 
    
  }
}

void MainWindow::showRunning(bool running)
{
	_startBtn->setOn(running);
	_startBtn->setTextLabel(running ? "Stop" : "Start", FALSE);
}

void MainWindow::initWhatsThis()
{
	QWhatsThis::add(brh_widget,
		"Zooming is enabled until the selected area gets "
		"too small for the significance on the axes.\n\n"
    	"You can zoom in using the left mouse button.\n"
    	"The middle mouse button is used to go back to the "
	  	"previous zoomed area.\n"
		"The right mouse button is used to unzoom completely."
	);
	QWhatsThis::add(_startBtn,
		"Start generation of random points.\n\n"
		"The intention of this example is to show how to implement "
		"growing curves. The points will be generated and displayed "
		"one after the other.\n"
		"To check the performance, a small delay and a large number "
		"of points are useful. To watch the curve growing, a delay "
		" > 300 ms and less points are better.\n"
		"To inspect the curve, stacked zooming is implemented using the "
		"mouse buttons on the plot."
	);
}




void MainWindow::socketReadyRead() {
  // read from the server
  int time, freq, volt, power;

  //  printf("Receiving a data from the server \n");
  while (socket->canReadLine()) {
    //    printf("Get: %s \n", socket->readLine().ascii());
    sscanf(socket->readLine().ascii(), "%d %d %d %d", &time, &freq, &volt, &power);
    printf("Recv time = %d , freq = %d , volt = %d , power = %d \n", time, freq, volt, power);
    brh_widget->appendData(time, freq, volt, power);
  }
} 

void MainWindow::socketConnected() {
  // now the socket is connected
  showRunning(TRUE);
  brh_widget->resetEnergy();

} 

void MainWindow::socketConnectionClosed() {
  bool running = FALSE;

  _startBtn->setOn(running);
  _startBtn->setTextLabel(running ? "Stop" : "Start", FALSE);
}

void MainWindow::socketError(int e) {
  QMessageBox::information(0, "Socket Error",
			   "There is a problem connecting to remote BRH board. \n Please check the hardware connection \n", 
			   QMessageBox::Ok|QMessageBox::Default);
  showRunning(FALSE);
				 
  
}

