#include <qpainter.h>
#include <qwt_plot.h>
#include <qwt_plot_canvas.h>
#include <qwt_curve.h>
#include <qwt_scale.h>
#include <qwt_plot_dict.h>
#include "realtimeplot.h"

IncrementalPlot::IncrementalPlot(QWidget *parent, const char* name): 
	QwtPlot(parent, name)
{
}

void IncrementalPlot::appendCurvePoint(long curveId, double x, double y)
{
	appendCurveData(curveId, &x, &y, 1);
}

void IncrementalPlot::drawCurveIntervall(long curveId, int from, int to)
{
    // This one might be a candidate to become a member of
    // QwtPlot. It paints only a intervall of points what is
    // essential for appending points. Using replot instead
    // is simply to slow for curves with a lot of points.

    QwtPlotCurve *curve = IncrementalPlot::curve(curveId);
	if ( curve == 0 )
		return;

	QPainter p(canvas());

    p.setClipping(TRUE);
    p.setClipRect(canvas()->rect());

    curve->draw(&p,  
		canvasMap(curve->xAxis()), canvasMap(curve->yAxis()),
		from, to);
}
