#ifndef _BRHWIDGET_H_
#define _BRHWIDGET_H_ 1

#include <qpoint.h>
#include <qpixmap.h>
#include <qwidget.h>
#include "zoomplot.h"

class ZoomPlot;

class BRHWidgetWindow: public QWidget
{
  Q_OBJECT

public:
  BRHWidgetWindow(QWidget *parent = NULL);

  virtual QSize sizeHint() const;

  void appendData(int time, int freq, int volt, int power);
  void resetEnergy();

private:
  void initCurve();

signals:
	void running(bool);

public slots:
	void stop();

protected:
// virtual void resizeEvent(QResizeEvent *);  
private:
  ZoomPlot *freq_plot;
  ZoomPlot *volt_plot;
  ZoomPlot *power_plot;
  ZoomPlot *energy_plot;
  long freq_curveId;
  long volt_curveId;
  long power_curveId;
  long energy_curveId;

  long total_energy;

  int prev_power;
  int prev_time;
   
  int pencolor;
  int start_time;
};

#endif /* _BRHWIDGET_H_ */
