#include <stdlib.h>
#include <qlayout.h>
#include <qframe.h>
#include <qfont.h>
#include <qevent.h>
#include <qlabel.h>
#include "brhwidget.h"

#define XRANGE 60000
#define YRANGE 100

BRHWidgetWindow::BRHWidgetWindow(QWidget *parent):
  QWidget(parent),
  freq_curveId(0),
  volt_curveId(0),
  power_curveId(0),
  energy_curveId(0),
  pencolor(0)
{

  QVBoxLayout* vlayout = new QVBoxLayout(this);
  QFont font;

  font.setWeight(QFont::Bold);
  font.setPointSize(14);

  QLabel *freq_label = new QLabel(this);
  freq_label->setFrameStyle(QFrame::NoFrame);
  freq_label->setText("\nFrequency Plot\n");
  freq_label->setFont(font);
  
  vlayout->addWidget(freq_label);

  freq_plot = new ZoomPlot(this);
  freq_plot->setGeometry(10, 10, 1500, 200);
  freq_plot->setAxisTitle(QwtPlot::xBottom, "Time(millisecond)");
  freq_plot->setAxisTitle(QwtPlot::yLeft, "Normalized Frequency (x400 MHz");
  freq_plot->setAutoLegend(TRUE);
  freq_plot->setAxisScale(QwtPlot::xBottom, 0, XRANGE, 0 );
  freq_plot->setAxisScale(QwtPlot::yLeft, 0, YRANGE, 0);
  freq_plot->setAxisMaxMinor(QwtPlot::xBottom, 10);
  freq_plot->replot();
  
  vlayout->addWidget(freq_plot); 

  QLabel *volt_label = new QLabel(this);
  volt_label->setFrameStyle(QFrame::NoFrame);
  volt_label->setText("Voltage Plot \n");
  volt_label->setFont(font);
  

  vlayout->addWidget(volt_label);

  volt_plot = new ZoomPlot(this);
  volt_plot->setGeometry(10, 220, 1500, 200);
  volt_plot->setAxisTitle(QwtPlot::xBottom, "Time(millisecond)");
  volt_plot->setAxisTitle(QwtPlot::yLeft, "Normalized Voltage (x1.60 V)");
  volt_plot->setAutoLegend(TRUE);
  volt_plot->setAxisScale(QwtPlot::xBottom, 0, XRANGE, 0 );
  volt_plot->setAxisScale(QwtPlot::yLeft, 0, YRANGE, 0);
  volt_plot->setAxisMaxMinor(QwtPlot::xBottom, 10);
  volt_plot->replot();

  vlayout->addWidget(volt_plot);

  QLabel *power_label = new QLabel(this);
  power_label->setFrameStyle(QFrame::NoFrame);
  power_label->setText("Power Plot\n");
  power_label->setFont(font);
  

  vlayout->addWidget(power_label);

  power_plot = new ZoomPlot(this);
  power_plot->setGeometry(10, 430, 1500, 200);
  power_plot->setAxisTitle(QwtPlot::xBottom, "Time(millisecond)");
  power_plot->setAxisTitle(QwtPlot::yLeft, "Normalized Power (x550 mW)");
  power_plot->setAutoLegend(TRUE);
  power_plot->setAxisScale(QwtPlot::xBottom, 0, XRANGE, 0 );
  power_plot->setAxisScale(QwtPlot::yLeft, 0, YRANGE, 0);
  power_plot->setAxisMaxMinor(QwtPlot::xBottom, 10);
  power_plot->replot();


  vlayout->addWidget(power_plot);

  QLabel *energy_label = new QLabel(this);
  energy_label->setFrameStyle(QFrame::NoFrame);
  energy_label->setText("Energy Plot\n");
  energy_label->setFont(font);
  

  vlayout->addWidget(energy_label);

  energy_plot = new ZoomPlot(this);
  energy_plot->setGeometry(10, 640, 1500, 200);
  energy_plot->setAxisTitle(QwtPlot::xBottom, "Time(millisecond)");
  energy_plot->setAxisTitle(QwtPlot::yLeft, "Normalized Energy");
  energy_plot->setAutoLegend(TRUE);
  energy_plot->setAxisScale(QwtPlot::xBottom, 0, XRANGE, 0 );
  energy_plot->setAxisScale(QwtPlot::yLeft, 0, YRANGE, 0);
  energy_plot->setAxisMaxMinor(QwtPlot::xBottom, 10);
  energy_plot->replot();

  vlayout->addWidget(energy_plot);
  
  vlayout->activate();
  
  initCurve();

}

void BRHWidgetWindow::appendData(int time, int freq, int volt, int power)
{
  int energy;
  int plottime;

  
  if (start_time == 0) start_time = time;
  plottime = time-start_time;
  freq_plot->appendCurvePoint(freq_curveId, plottime, (freq* 100)/4000);
  volt_plot->appendCurvePoint(volt_curveId, plottime, (volt* 100)/1600);
  power_plot->appendCurvePoint(power_curveId, plottime, (power* 100)/550);
  energy = ((time - prev_time) * prev_power)/100;
  total_energy += energy;
  printf("Plot time = %d freq = %d , volt = %d, power = %d, energy = %d ; total_energy =  %lu \n", plottime, (freq*100)/8000, (volt*100)/1600, (power *100)/550, energy, (total_energy*11)/10000);
  prev_time = time;
  prev_power = power;
  energy_plot->appendCurvePoint(energy_curveId, plottime, (total_energy*11)/10000);
  
}

QSize BRHWidgetWindow::sizeHint() const
{
  return QSize(1000, 650);
}


/*
void BRHWidgetWindow::resizeEvent(QResizeEvent *e)
{
    freq_plot->resizeEvent(e);
    volt_plot->resizeEvent(e);
    energy_plot->resizeEvent(e);
    
}
*/

void BRHWidgetWindow::stop()
{

  //	if ( _timer )
  //	{
  //		_timer->stop();
		emit running(FALSE);
		//	}
}

void BRHWidgetWindow::initCurve()
{
	{
		freq_plot->removeCurveData(freq_curveId);
		freq_plot->removeCurve(freq_curveId);
		volt_plot->removeCurveData(volt_curveId);
		volt_plot->removeCurve(volt_curveId);
		power_plot->removeCurveData(power_curveId);
		power_plot->removeCurve(power_curveId);
		energy_plot->removeCurveData(energy_curveId);
		energy_plot->removeCurve(energy_curveId);
	}
	const QColor &c = white;

	freq_curveId = freq_plot->insertCurve("");
	freq_plot->setCurveStyle(freq_curveId, QwtCurve::Steps);
	freq_plot->setCurveSymbol(freq_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(c), QPen(c), QSize(5, 5)) );

	volt_curveId = volt_plot->insertCurve("");
	volt_plot->setCurveStyle(volt_curveId, QwtCurve::Steps);
	volt_plot->setCurveSymbol(volt_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(c), QPen(c), QSize(5, 5)) );

	power_curveId = power_plot->insertCurve("");
	power_plot->setCurveStyle(power_curveId, QwtCurve::Steps);
	power_plot->setCurveSymbol(power_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(c), QPen(c), QSize(5, 5)) );


	energy_curveId = energy_plot->insertCurve("");
	energy_plot->setCurveStyle(energy_curveId, QwtCurve::Steps);
	energy_plot->setCurveSymbol(energy_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(c), QPen(c), QSize(5, 5)) );


}

void  BRHWidgetWindow::resetEnergy(void) {
  total_energy = 0;
  prev_power = 0;
  prev_time = 0;
  start_time = 0;
  /* change color */
  QColor cc;
  switch (pencolor%5) {
  case 0: 
    cc = Qt::white; break;
  case 1:
    cc = Qt::magenta;   break;
  case 2:
    cc = Qt::red;   break;
  case 3:
    cc = Qt::green;   break;
  case 4:
    cc = Qt::black;   break;
  }

  freq_plot->setCurveSymbol(freq_curveId, QwtSymbol(QwtSymbol::XCross,
	     QBrush(cc), QPen(cc), QSize(5, 5)) );
  
  volt_plot->setCurveSymbol(volt_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(cc), QPen(cc), QSize(5, 5)) );


  power_plot->setCurveSymbol(power_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(cc), QPen(cc), QSize(5, 5)) );

  energy_plot->setCurveSymbol(energy_curveId, QwtSymbol(QwtSymbol::XCross,
		QBrush(cc), QPen(cc), QSize(5, 5)) );

  pencolor++;

}
