/*
 * vscale_thread.c: code to support energy-aware voltage-scaling 
 * algorithm on processor. This is a kernel thread to do the voltage
 * and frequency scaling outside the context switch which is necessary 
 * for BitsyX and IPAQ platform.
 *
 *
 * Real-time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

///!!!!!! NOTE:::: IPAQ coding is not finished yet !!!

#ifdef ENERGY_AWARE
#ifdef __bitsyx__

#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>
#include <rk/timespec.h>
#include <linux/time.h>
#include <linux/sched.h>
#include <asm/processor.h>
#include <asm/uaccess.h>
#include <asm/signal.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/types.h>
#include <asm/hardware.h>
#ifdef CONFIG_MEASURE
#include <linux/measure.h>
#endif				/* CONFIG_MEASURE */

extern unsigned int cpufreq_get(int cpu);
extern int cpufreq_set(unsigned int freq);


extern int rk_going_down; /* from timer.c */
extern int freqIndex; /* from cpu_energy_aware.c */
extern int freq_set[]; /* from cpu_energy_aware.c */
static int vscale_thread_body(void *unused);
wait_queue_head_t    vscale_wait;
static int request_pending = 0;
static int vscale_busy = 0;
static pid_t vscale_pid = 0;
int vscale_thread_init() {
   // start daemon
  // int kernel_thread( int (*fn) (void *), void *arg, unsigned long flags);
  init_waitqueue_head(&vscale_wait);
  vscale_pid = kernel_thread(vscale_thread_body, NULL,
			     CLONE_SIGNAL | CLONE_VM);
  printk("kernel_thread is done \n");
 
  return vscale_pid;
}

void vscale_thread_wakeup() {

  
  /* Send request_pending flag when a request comes in when 
   * (1) the vscale thread is not created    or
   * (2) the vscale_thread has not done with the voltage/frequency setting 
   *     of the previous request.
   */
  if ((!vscale_pid) || vscale_busy) {
    /* notify the thread about the new request pending */
    /* request_pending states the number of pending requests */
    request_pending++;
  } else {
    /* wake it up */
    wake_up(&vscale_wait);
  }
}


/* The daemon */
static int vscale_thread_body(void *unused) {
  unsigned int current_freq;
  static int setFreqIndex = 3;

  printk("vscale kernel thread is up and running \n");
  DECLARE_WAITQUEUE(wait, current);


  daemonize();
  reparent_to_init();
  strcpy(current->comm,"rk_vscale");
  sigfillset(&current->blocked);

  while (!rk_going_down) {
    add_wait_queue(&vscale_wait, &wait);
    
    // no request pending; put the thread to sleep
    if (!request_pending) {
      
      set_current_state(TASK_INTERRUPTIBLE);

      vscale_busy = 0;
      // wait until the rk module send signal
      schedule_timeout(MAX_SCHEDULE_TIMEOUT);
    }

    vscale_busy = 1;
    request_pending = 0;  // just need to service the current request;                          
    current->state = TASK_RUNNING;

    // set the voltage and frequency
    if (freqIndex != setFreqIndex) {
      cpufreq_set(freq_set[freqIndex]);

      // just checking if the hw is really updated
      
      current_freq = cpufreq_get( smp_processor_id() );
      if (current_freq != freq_set[freqIndex]) {
	  printk("Set new frequency error!!: current_freq = %d , ideal freq = %d \n", current_freq,  freq_set[freqIndex]);
	
      }
      setFreqIndex = freqIndex;
    }

    remove_wait_queue(&vscale_wait, &wait);

  }
    
  printk("rk_vscale thread exiting \n");
  return 0;
}


#endif /* __bitsyx__ */

#endif /* ENERGY_AWARE */
