/*
 * linux/include/asm-arm/arch-pxa/adsbitsyx.h
 *
 * This file contains the hardware specific definitions for the
 * ADS BitsyX Board
 */

#ifndef __ASM_ARCH_HARDWARE_H
#error "include <asm/hardware.h> instead"
#endif

#define ADSBITSYX_CPLD_BASE	   PXA_CS2_PHYS
#define ADSBITSYX_CPLD_VBASE	   (0xf1000000)
#define ADSBITSYX_p2v( x )	   ((x) - ADSBITSYX_CPLD_BASE + ADSBITSYX_CPLD_VBASE)
#define ADSBITSYX_v2p( x )	   ((x) - ADSBITSYX_CPLD_VBASE + ADSBITSYX_CPLD_BASE)

#define _ADSBITSYX_CPLD_REV        (ADSBITSYX_CPLD_BASE + 0x0004)
#define _ADSBITSYX_CPLD_PCON       (ADSBITSYX_CPLD_BASE + 0x0010)
#define _ADSBITSYX_CPLD_SUPPC      (ADSBITSYX_CPLD_BASE + 0x0014)
#define _ADSBITSYX_CPLD_SUPPC2     (ADSBITSYX_CPLD_BASE + 0x0018)

#define ADSBITSYX_CPLD_REV_MASK    0xF0

#define ADSBITSYX_PCON_PANEL_ON    0x01 // active low
#define ADSBITSYX_PCON_AUDIO_ON    0x02 // active low
#define ADSBITSYX_PCON_AUDIOPA_ON  0x04
#define ADSBITSYX_PCON_COM1_3_ON   0x08
#define ADSBITSYX_PCON_CONN_B_PE1  0x10 // PS2 Keyboard on Rev A connector board
#define ADSBITSYX_PCON_CONN_B_PE2  0x20 // Port 2 RS232 on Rev A connector board

#define ADSBITSYX_SUPPC_VEE_ON     0x01
#define ADSBITSYX_SUPPC_TS_SPI_SEL 0x02
#define ADSBITSYX_SUPPC_CB_SPI_SEL 0x04

#define ADSBITSYX_SUPPC2_LED0      0x01
#define ADSBITSYX_SUPPC2_RESETAVR  0x02 // active low
#define ADSBITSYX_SUPPC2_AVR_WKP   0x04 // active low
#define ADSBITSYX_SUPPC2_IRDAON    0x08 // active low
#define ADSBITSYX_SUPPC2_SPARE0    0x40 // routed to J7
#define ADSBITSYX_SUPPC2_KP_WKP    0x40

/* Virtual register addresses */

#ifndef __ASSEMBLY__
#define ADSBITSYX_CPLD_REV         (*((volatile u_char *) ADSBITSYX_p2v(_ADSBITSYX_CPLD_REV)))
#define ADSBITSYX_CPLD_PCON        (*((volatile u_char *) ADSBITSYX_p2v(_ADSBITSYX_CPLD_PCON)))
#define ADSBITSYX_CPLD_SUPPC       (*((volatile u_char *) ADSBITSYX_p2v(_ADSBITSYX_CPLD_SUPPC)))
#define ADSBITSYX_CPLD_SUPPC2      (*((volatile u_char *) ADSBITSYX_p2v(_ADSBITSYX_CPLD_SUPPC2)))

#define ADSBITSYX_CPLD_REV_NUM     ((ADSBITSYX_CPLD_REV & ADSBITSYX_CPLD_REV_MASK) >> 4)
// Rev 1 BitsyX has CPLD Rev 1 only
// Rev 2 BitsyX has starts with CPLD Rev 2
#define ADSBITSYX_REV              ((ADSBITSYX_CPLD_REV_NUM < 2) ? 0x01 : 0x02)
#endif

#define ADSBITSYX_SA1111_BASE      PXA_CS3_PHYS
// #define SA1111_BASE             ADSBITSYX_SA1111_BASE

#define ADSBITSYX_ETH_OFFSET       0x300
#define ADSBITSYX_COMA_OFFSET      0x400
#define ADSBITSYX_COMB_OFFSET      0x410
#define ADSBITSYX_COMC_OFFSET      0x420
#define ADSBITSYX_COMD_OFFSET      0x430
#define ADSBITSYX_CFBUS_INT_OFFSET 0x440
#define ADSBITSYX_CFBUS_MSK_OFFSET 0x450
#define ADSBITSYX_CFBUS_RST_OFFSET 0x460
#define ADSBITSYX_CFBUS_ID_OFFSET  0x500

#define ADSBITSYX_CFBUS_RST_ETH    0x01
#define ADSBITSYX_CFBUS_RST_UART   0x02

#define ADSBITSYX_CFBUS_INT_COMA   0x01
#define ADSBITSYX_CFBUS_INT_COMB   0x02
#define ADSBITSYX_CFBUS_INT_COMC   0x04
#define ADSBITSYX_CFBUS_INT_COMD   0x08
#define ADSBITSYX_CFBUS_INT_ETH    0x10

#define ADSBITSYX_CFBUS_MSK_COMA   0x01
#define ADSBITSYX_CFBUS_MSK_COMB   0x02
#define ADSBITSYX_CFBUS_MSK_COMC   0x04
#define ADSBITSYX_CFBUS_MSK_COMD   0x08
#define ADSBITSYX_CFBUS_MSK_ETH    0x10

#define ADSBITSYX_CFBUS_BASE       0x3c000000
#define ADSBITSYX_CFBUS_VBASE      0xf0000000

#define ADSBITSYX_ETH_BASE         (ADSBITSYX_CFBUS_BASE + ADSBITSYX_ETH_OFFSET)
#define ADSBITSYX_ETH_VBASE        (ADSBITSYX_CFBUS_VBASE + ADSBITSYX_ETH_OFFSET)
#define ADSBITSYX_COMA_BASE        (ADSBITSYX_CFBUS_BASE + ADSBITSYX_COMA_OFFSET)
#define ADSBITSYX_COMB_BASE        (ADSBITSYX_CFBUS_BASE + ADSBITSYX_COMB_OFFSET)
#define ADSBITSYX_COMC_BASE        (ADSBITSYX_CFBUS_BASE + ADSBITSYX_COMC_OFFSET)
#define ADSBITSYX_COMD_BASE        (ADSBITSYX_CFBUS_BASE + ADSBITSYX_COMD_OFFSET)

#ifndef __ASSEMBLY__
extern void adsbitsyx_turn_audio_on(void);
extern void adsbitsyx_turn_audio_off(void);
extern void adsbitsyx_lcd_on(void);
extern void adsbitsyx_lcd_off(void);
extern void adsbitsyx_serial_on(void);
extern void adsbitsyx_serial_off(void);
extern void adsbitsyx_set_cpu_voltage(unsigned int freq);
#endif
