/*
 * linux/include/asm-arm/arch-pxa/adsagx.h
 *
 * This file contains the hardware specific definitions for the
 * ADS AGX Board
 */

#ifndef __ASM_ARCH_HARDWARE_H
#error "include <asm/hardware.h> instead"
#endif

#ifndef __ASSEMBLY__
void adsagx_turn_audio_on(void);
void adsagx_turn_audio_off(void);
#endif

#define ADSAGX_CPLD_BASE		PXA_CS2_PHYS
#define ADSAGX_CPLD_VBASE		0xf1000000
#define ADSAGX_p2v( x )		((x) - ADSAGX_CPLD_BASE + ADSAGX_CPLD_VBASE)
#define ADSAGX_v2p( x )		((x) - ADSAGX_CPLD_VBASE + ADSAGX_CPLD_BASE)

#define _ADSAGX_CPLD_SPI_TX         (ADSAGX_CPLD_BASE + 0x20000)
#define _ADSAGX_CPLD_SPI_RX         (ADSAGX_CPLD_BASE + 0x20004)
#define _ADSAGX_CPLD_SPI_EN         (ADSAGX_CPLD_BASE + 0x20008)
#define _ADSAGX_CPLD_DDR            (ADSAGX_CPLD_BASE + 0x40000)
#define _ADSAGX_CPLD_DRR            (ADSAGX_CPLD_BASE + 0x40004)
#define _ADSAGX_CPLD_DWR            (ADSAGX_CPLD_BASE + 0x40004)
#define _ADSAGX_CPLD_CR0            (ADSAGX_CPLD_BASE + 0x60000)
#define _ADSAGX_CPLD_CR1            (ADSAGX_CPLD_BASE + 0x60004)
#define _ADSAGX_CPLD_CR2            (ADSAGX_CPLD_BASE + 0x60008)
#define _ADSAGX_CPLD_CR3            (ADSAGX_CPLD_BASE + 0x6000C)
#define _ADSAGX_CPLD_REV            (ADSAGX_CPLD_BASE + 0x60010)
#define _ADSAGX_CPLD_IRQ_EN         (ADSAGX_CPLD_BASE + 0x80000)
#define _ADSAGX_CPLD_IRQ_FL         (ADSAGX_CPLD_BASE + 0x80008)
#define _ADSAGX_CPLD_PCMCIA_CR      (ADSAGX_CPLD_BASE + 0xA0000)
#define _ADSAGX_CPLD_PCMCIA_IRQ_EN  (ADSAGX_CPLD_BASE + 0xA0004)
#define _ADSAGX_CPLD_PCMCIA_IRQ_FL  (ADSAGX_CPLD_BASE + 0xA0008)
#define _ADSAGX_CPLD_PCMCIA_SR      (ADSAGX_CPLD_BASE + 0xA000C)
#define _ADSAGX_CPLD_UART1          (ADSAGX_CPLD_BASE + 0xC0000)
#define _ADSAGX_CPLD_UART2          (ADSAGX_CPLD_BASE + 0xC0020)
#define _ADSAGX_CPLD_UART3          (ADSAGX_CPLD_BASE + 0x00000)
#define _ADSAGX_CPLD_UART4          (ADSAGX_CPLD_BASE + 0x00020)
#define _ADSAGX_CPLD_CAN_ADDR       (ADSAGX_CPLD_BASE + 0xE0000)
#define _ADSAGX_CPLD_CAN_DATA       (ADSAGX_CPLD_BASE + 0xE0004)

#ifndef __ASSEMBLY__
#define ADSAGX_CPLD_SPI_TX          (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_SPI_TX)))
#define ADSAGX_CPLD_SPI_RX          (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_SPI_RX)))
#define ADSAGX_CPLD_SPI_EN          (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_SPI_EN)))
#define ADSAGX_CPLD_DDR             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_GPDR)))
#define ADSAGX_CPLD_DRR             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_GPSR)))
#define ADSAGX_CPLD_DWR             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_GPSR)))
#define ADSAGX_CPLD_CR0             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CR0)))
#define ADSAGX_CPLD_CR1             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CR1)))
#define ADSAGX_CPLD_CR2             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CR2)))
#define ADSAGX_CPLD_CR3             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CR3)))
#define ADSAGX_CPLD_REV             (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_REV)))
#define ADSAGX_CPLD_IRQ_EN          (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_IRQ_EN)))
#define ADSAGX_CPLD_IRQ_FL          (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_IRQ_FL)))
#define ADSAGX_CPLD_PCMCIA_CR       (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_PCMCIA_CR)))
#define ADSAGX_CPLD_PCMCIA_IRQ_EN   (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_PCMCIA_IRQ_EN)))
#define ADSAGX_CPLD_PCMCIA_IRQ_FL   (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_PCMCIA_IRQ_FL)))
#define ADSAGX_CPLD_PCMCIA_SR       (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_PCMCIA_SR)))
#define ADSAGX_CPLD_UART1           (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_UART1)))
#define ADSAGX_CPLD_UART2           (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_UART2)))
#define ADSAGX_CPLD_UART3           (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_UART3)))
#define ADSAGX_CPLD_UART4           (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_UART4)))
#define ADSAGX_CPLD_CAN_ADDR        (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CAN_ADDR)))
#define ADSAGX_CPLD_CAN_DATA        (*((volatile u_char *)ADSAGX_p2v(_ADSAGX_CPLD_CAN_DATA)))
#endif

/* IO bits */

#define ADSAGX_CPLD_SPI_ENABLE     0x01

#define ADSAGX_CPLD_CR0_SW0        0x01
#define ADSAGX_CPLD_CR0_SW1        0x02
#define ADSAGX_CPLD_CR0_SW2        0x04
#define ADSAGX_CPLD_CR0_SW3        0x08

#define ADSAGX_CPLD_CR1_AMP        0x01
#define ADSAGX_CPLD_CR1_CODEC      0x02
#define ADSAGX_CPLD_CR1_BTL        0x04
#define ADSAGX_CPLD_CR1_COM3EN     0x10
#define ADSAGX_CPLD_CR1_IRDAON     0x20

#define ADSAGX_CPLD_CR2_CLKSEL0    0x01
#define ADSAGX_CPLD_CR2_CLKSEL1    0x02
#define ADSAGX_CPLD_CR2_PLLOFF     0x04
#define ADSAGX_CPLD_CR2_CLKPWR     0x08

#define ADSAGX_CPLD_CR3_PNLON      0x01
#define ADSAGX_CPLD_CR3_VEECRL     0x02
#define ADSAGX_CPLD_CR3_BLON       0x04
#define ADSAGX_CPLD_CR3_GC_PWR     0x08

#define ADSAGX_CPLD_REV_FW_MSK     0x0F
#define ADSAGX_CPLD_REV_HW_MSK     0xF0

#define ADSAGX_CPLD_IRQ_SSP        0x01
#define ADSAGX_CPLD_IRQ_CAN        0x02
#define ADSAGX_CPLD_IRQ_ETH        0x04
#define ADSAGX_CPLD_IRQ_EXT        0x08
#define ADSAGX_CPLD_IRQ_UART1      0x01
#define ADSAGX_CPLD_IRQ_UART2      0x02
#define ADSAGX_CPLD_IRQ_UART3      0x04
#define ADSAGX_CPLD_IRQ_UART4      0x08

#define ADSAGX_CPLD_PCMCIA_CR_B_3V 0x01
#define ADSAGX_CPLD_PCMCIA_CR_B_5V 0x02
#define ADSAGX_CPLD_PCMCIA_CR_A_3V 0x04
#define ADSAGX_CPLD_PCMCIA_CR_A_5V 0x08
#define ADSAGX_CPLD_PCMCIA_CR_B_RS 0x10
#define ADSAGX_CPLD_PCMCIA_CR_A_RS 0x20

#define ADSAGX_CPLD_PCMCIA_IRQ_B_STS 0x01
#define ADSAGX_CPLD_PCMCIA_IRQ_A_STS 0x02
#define ADSAGX_CPLD_PCMCIA_IRQ_B_DET 0x04
#define ADSAGX_CPLD_PCMCIA_IRQ_A_DET 0x08
#define ADSAGX_CPLD_PCMCIA_IRQ_B_IRQ 0x10
#define ADSAGX_CPLD_PCMCIA_IRQ_A_IRQ 0x20

#define ADSAGX_CPLD_PCMCIA_IRQ_MASK 0x3F

#define ADSAGX_CPLD_PCMCIA_STA_B_IRQ 0x01
#define ADSAGX_CPLD_PCMCIA_STA_A_IRQ 0x02
#define ADSAGX_CPLD_PCMCIA_STA_B_SPK 0x04
#define ADSAGX_CPLD_PCMCIA_STA_A_SPK 0x08
#define ADSAGX_CPLD_PCMCIA_STA_B_DET 0x10
#define ADSAGX_CPLD_PCMCIA_STA_A_DET 0x20


#define ADSAGX_ETH_BASE         	PXA_CS4_PHYS
#define ADSAGX_ETH_VBASE		0xf0000000
