/*
 * Copyright (C) Carnegie Mellon University
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#define ENERGY_AWARE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <signal.h>


void print_usage(char *cmdname)
{
    printf("Usage: %s \n", cmdname);
    printf("NODVS     - policy 0\n");
    printf("SYS_CLOCK - policy 1 \n");
    printf("PM_CLOCK  - policy 2 \n");
}

int main(int argc, char *argv[])
{

    int policy = rk_cpu_energy_aware_get_policy();
    switch (policy) {
    case 0: printf("NODVS\n");
      break;
    case 1: printf("SYS_CLOCK\n");
      break;
    case 2: printf("PM_CLOCK\n");
      break;
    }
    return 0;
}
