/*
 * ltc1663.h
 *
 * Copyright (C) 2003 Applied Data Systems
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef LTC1663_H
#define LTC1663_H

#define LTC1663_I2C_SLAVE_ADDR	0x20

#define I2C_NAME_LTC1663	"LTC1663"
#define PROC_LTC1663_NAME	"driver/ltc1663"

#define SY_UPDATE_STOP	0x00	/* Update on STOP only (Power-on Default) */
#define SY_UPDATE_SYNC	0x01	/* Update on Ack of SYNC Address only */
#define SD_ENABLE	0x00	/* Standard operating mode (Power-on Default) */
#define SD_DISABLE	0x02	/* Power down (never use this - voltage becomes unregulated!) */
#define BG_SUPPLY_REF	0x00	/* Select supply as the reference (Power-on Default) */
#define BG_INTERNAL_REF	0x04	/* Select internal bandgap reference */

#define LTC1663_SY	0x01	/* Sync */
#define LTC1663_SD	0x02	/* Shutdown */ 
#define LTC1663_BG	0x04	/* Internal Voltage Ref */

#define DAC_SYNC_ADDR	0x7e	/* SYNC Address for multiple devices */

#endif
