/*   Copyright (C) 2002 Robert Whaley

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

#include <linux/rtc.h>

#include <linux/config.h>
#include <linux/module.h>
#include <linux/version.h>

#include <linux/kernel.h>
#include <linux/poll.h>
#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/rtc.h>
#include <linux/string.h>
#include <linux/miscdevice.h>
#include <linux/proc_fs.h>

#include "ds1307.h"

#ifdef CONFIG_I2C_ALGOBIT

static void setsda(void *data, int state)
{
	if (state)
		GPDR &= ~GPIO_GPIO11;
	else
		GPDR |= GPIO_GPIO11;
}

static void setscl(void *data, int state)
{
	if (state)
		GPDR &= ~GPIO_GPIO12;
	else
		GPDR |= GPIO_GPIO12;
}

static int getsda(void *data)
{
        GPDR &= ~GPIO_GPIO11;
	return GPLR & GPIO_GPIO11;
}

static int getscl(void *data)
{
        GPDR &= ~GPIO_GPIO12;
	return GPLR & GPIO_GPIO12;
}

static struct i2c_algo_bit_data ads_data = {
	setsda:		setsda,
	setscl:		setscl,
	getsda:		getsda,
	getscl:		getscl,
	udelay:		 80,
	mdelay:		 80,
	timeout:	100
};
#endif

static struct i2c_adapter ads_ops = {
	name:			"DS1307-RTC",
#ifdef CONFIG_I2C_ALGOBIT
	algo_data:		&ads_data,
#endif
};

static int __init i2c_ads_init(void)
{
        int ret;
#ifdef CONFIG_I2C_ALGOBIT
	int i2c_bit_add_bus(struct i2c_adapter *adap);

	GPCR = GPIO_GPIO11 | GPIO_GPIO12;
		
	ret = i2c_bit_add_bus(&ads_ops);

#elif defined(CONFIG_ADSSIO_I2C_ALGO)
	int i2c_sio_add_bus(struct i2c_adapter *adap);

	ret = i2c_sio_add_bus(&ads_ops);
#else
#error "Need to have I2C Alogrithm defined."
#endif
	return ret;
}

module_init(i2c_ads_init);

MODULE_AUTHOR ("Applied Data Systems");
MODULE_LICENSE("GPL");
