/*
 * linux/arch/arm/mach-pxa/leds.c
 *
 * xscale LEDs dispatcher
 * 
 * Copyright (C) 2001 Nicolas Pitre
 * 
 * Copyright (c) 2001 Jeff Sutherland, Accelent Systems Inc.
 */
#include <linux/config.h>
#include <linux/init.h>

#include <asm/leds.h>
#include <asm/mach-types.h>

#include "leds.h"

static int __init
pxa_leds_init(void)
{
	if (machine_is_lubbock())
		leds_event = lubbock_leds_event;
	if (machine_is_pxa_idp())
		leds_event = idp_leds_event;
	if (machine_is_pxa_cerf())
		leds_event = pxa_cerf_leds_event;
	if (machine_is_adsbitsyx())
		leds_event = adsbitsyx_leds_event;
	if (machine_is_adsagx())
		leds_event = adsagx_leds_event;

	leds_event(led_start);
	return 0;
}

__initcall(pxa_leds_init);
