/*
 *  linux/arch/arm/mach-pxa/leds-adsagx.c
 *
 * ADS AGX LED
 */
#include <linux/config.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/leds.h>
#include <asm/system.h>

#include "leds.h"


#define LED_STATE_ENABLED	1
#define LED_STATE_CLAIMED	2

static unsigned int led_state;
static unsigned int hw_led_state;

#define LED_TIMER       GPIO_bit(20)  /* green heartbeat */
#define LED_USER        GPIO_bit(19)  /* amber, boots to on */
#define LED_IDLE        GPIO_bit(21)  /* red has the idle led, if any */

#define LED_MASK	(LED_TIMER | LED_USER | LED_IDLE)

void adsagx_leds_event(led_event_t evt)
{
	unsigned long flags;

	local_irq_save(flags);

	switch (evt) {
	case led_start:
		hw_led_state = 0;        /* positive logic */
		led_state = LED_STATE_ENABLED;
		break;

	case led_stop:
		led_state &= ~LED_STATE_ENABLED;
		break;

	case led_claim:
		led_state |= LED_STATE_CLAIMED;
		hw_led_state = LED_MASK;
		break;

	case led_release:
		led_state &= ~LED_STATE_CLAIMED;
		hw_led_state = LED_MASK;
		break;

#ifdef CONFIG_LEDS_TIMER
	case led_timer:
		if (!(led_state & LED_STATE_CLAIMED))
			hw_led_state ^= LED_TIMER;
		break;
#endif

#ifdef CONFIG_LEDS_CPU
	case led_idle_start:
		if (!(led_state & LED_STATE_CLAIMED))
			hw_led_state &= ~LED_IDLE;
		break;

	case led_idle_end:
		if (!(led_state & LED_STATE_CLAIMED))
			hw_led_state |= LED_IDLE;
		break;
#endif

	case led_green_on:
		break;

	case led_green_off:
		break;

	case led_amber_on:
		hw_led_state |= LED_USER;
		break;

	case led_amber_off:
		hw_led_state &= ~LED_USER;
		break;

	case led_red_on:
		break;

	case led_red_off:
		break;

	default:
		break;
	}

	if  (led_state & LED_STATE_ENABLED) {
		GPSR0 = hw_led_state;
		GPCR0 = hw_led_state ^ LED_MASK;
	}

	local_irq_restore(flags);
}
