/* fpont 12/99 */
/* pont.net    */
/* tcpClient.c */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h> /* close */

#define SUCCESS 0
#define ERROR   1


#define SERVER_PORT 15000
#define MAX_MSG 100

int main (int argc, char *argv[]) {

  int sd, rc, n;
  struct sockaddr_in localAddr, servAddr;
  struct hostent *h;
  static char rcv_msg[MAX_MSG];
  
  if(argc < 3) {
    printf("usage: %s <server> <data1> <data2> ... <dataN>\n",argv[0]);
    return 1;
  }

  h = gethostbyname(argv[1]);
  if(h==NULL) {
    printf("%s: unknown host '%s'\n",argv[0],argv[1]);
    return 1;
  }

  servAddr.sin_family = h->h_addrtype;
  memcpy((char *) &servAddr.sin_addr.s_addr, h->h_addr_list[0], h->h_length);
  servAddr.sin_port = htons(SERVER_PORT);

  /* create socket */
  sd = socket(AF_INET, SOCK_STREAM, 0);
  if(sd<0) {
    perror("cannot open socket ");
    return 1;
  }

  /* bind any port number */
  localAddr.sin_family = AF_INET;
  localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  localAddr.sin_port = htons(0);
  
  rc = bind(sd, (struct sockaddr *) &localAddr, sizeof(localAddr));
  if(rc<0) {
    printf("%s: cannot bind port TCP %u\n",argv[0],SERVER_PORT);
    perror("error ");
    return 1;
  }
				
  /* connect to server */
  rc = connect(sd, (struct sockaddr *) &servAddr, sizeof(servAddr));
  if(rc<0) {
    perror("cannot connect ");
    return 1;
  }

  while(1) {
    n = recv(sd, rcv_msg, MAX_MSG, 0);
    if (n<0) {
      perror(" cannot receive data ");
      return ERROR;
    } 
      else if (n==0) {
	printf(" connection closed by client\n");
	close(sd);
	break;
      } else {
	printf("get data :");
	rcv_msg[n] = '\0';
	printf("%s \n", rcv_msg);
      }
  }


return 0;
  
}

