/*
 * xscalemonserver.c
 *
 * Read information about freq, voltage, energy  of the /proc/ file system
 * and send those to the remote monitor
 *
 *
 * Updated by Saowanee (Apple) Saewong 4/30/2003
 */

#define RESERVATION
#define SUCCESS 0
#define ERROR   1

#define END_LINE 0x0A
#define SERVER_PORT 15000
#define MAX_MSG 100

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <rk/rk.h>
#include <rk/rk_error.h>
#include <rk/timespec.h>
#include <rk/posix_timers.h>
#define NUMRECORD 1200
#define NUMRESERVES 50
#define MAXBUFFERSIZE 5000
#ifdef RESERVATION
    rk_resource_set_t rs = NULL_RESOURCE_SET;
    rk_reserve_t cpu_rsv;
    rk_reserve_param_data_t rsv_param;
    struct timespec rsv_c, rsv_t;
    cpu_reserve_attr_data_t cpu_attr;
    int res;
#endif /* RESERVATION */

void rs_shutdown(rk_resource_set_t rs) 
{
    int res;

    if (rs!= NULL_RESOURCE_SET) {
	res = rk_resource_set_destroy(rs);
    	if (res != 0) {
		printf("rk_resource_set_destroy failed destroying RS %p", rs);
    	}
    }
    exit(0);
}


void print_usage(char *pname)
{
    fprintf(stderr,
	    "\nUsage: %s [--sec n] [--nsec n] [--rsvsec n] [--rsvnsec n] \n\n",
	    pname);
    fprintf(stderr, "eg. %s --sec 0 --nsec 500000000  --rsvsec 0 --rsvnsec 500000000 \n",
	    pname);
    fprintf(stderr,
	    "This program monitors ENERGY usage via /proc/ file system\n");
    fprintf(stderr, 
	    "The data will be sent to the remote monitor to plot");
    fprintf(stderr,
	    "Type Ctrl-C to finish. The log will be in a file named output\n");
}

void dump(int i)
{
    rs_shutdown(rs);
}

int main(int argc, char **argv)
{
  int _starttime;
  int _start_done;
  int max_energy_buffer, history_round, history_index;
  int c, reserve; 
      //numprocs;
    struct timespec period, start, now;
    FILE *fp;
    long nsec = 500000000;	//default 500ms
    long sec = 0;
    long rsvsec = 0; // default no reservation
    long rsvnsec = 0; 
    int i, n;
    char buff[1000];
    
    int time[1000], freq[1000], volt[1000], power[1000];
    int sd, newSd, cliLen;
    struct sockaddr_in cliAddr, servAddr;

    _start_done = 0; _starttime = 0;
    print_usage(argv[0]);

    sd = socket(AF_INET, SOCK_STREAM, 0);
    if(sd<0) {
      perror("cannot open socket ");
      return ERROR;
    }
    
    /* bind server port */
    servAddr.sin_family = AF_INET;
    servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servAddr.sin_port = htons(SERVER_PORT);
    
    if(bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr))<0) {
      perror("cannot bind port ");
      return ERROR;
    }
    
    listen(sd,5);
    
    while (1) {
	int option_index = 0;
	static struct option long_options[] = {
	    {"sec", 1, 0, 0},
	    {"nsec", 1, 0, 0},
	    {"rsvsec", 1, 0, 0},
	    {"rsvnsec", 1, 0, 0},
	    {0, 0, 0, 0}
	};

#define OPT_SEC 	0
#define OPT_NSEC 	1
#define OPT_RSVSEC      3
#define OPT_RSVNSEC     4
	c = getopt_long_only(argc, argv, "", long_options, &option_index);

	/* bunch of option handling... */
	if (c == -1)
	    break;
	switch (c) {
	case 0:

	    switch (option_index) {
	    case OPT_SEC:
		sec = atol(optarg);
		break;

	    case OPT_NSEC:
		nsec = atol(optarg);
		break;

	    case OPT_RSVSEC:
	        rsvsec = atol(optarg);
	        break;

	    case OPT_RSVNSEC:
	        rsvnsec = atol(optarg);
	        break;
	    }

	    break;
	case '?':
	    break;
	default:
	    printf("?? getopt returned character code 0%o ??\n", c);
	    //print_usage(argv[0]);
	}
    }
    if (optind < argc) {
	printf("undefined arguments....ignoring   ");
	while (optind < argc)
	    printf("%s ", argv[optind++]);
	printf("\n");
    }




    reserve  = 0;
    signal(SIGINT, dump);
 
    /* set period for this process */
    period.tv_sec = sec;
    period.tv_nsec = nsec;
    /* start 2 sec from now */
    start.tv_sec=2;
    start.tv_nsec=0;
    
#ifdef RESERVATION
    if ((rsvsec != 0) || (rsvnsec != 0)) {
      rs = rk_resource_set_create("monitor");
      if (((int) rs == -1) || (rs == NULL)) {
	printf("Cannot create resource set!!!\n");
	exit(-1);
      }
      
      clock_gettime(CLOCK_REALTIME, &now);
      
      timespec_add(start, now);
      
      rsv_c.tv_sec = rsvsec;
      rsv_c.tv_nsec = rsvnsec;
      rsv_t = period;
      rsv_param.enf_mode = RSV_HARD;
      //  rsv_param.enf_mode = RSV_SOFT;
      rsv_param.sch_mode = rsv_param.rep_mode = RSV_HARD;
      cpu_attr.compute_time = rsv_c;
      cpu_attr.period = rsv_t;
      cpu_attr.deadline = rsv_t;
      cpu_attr.blocking_time.tv_sec = 0;
      cpu_attr.blocking_time.tv_nsec = 0;
      cpu_attr.start_time = start;
      cpu_attr.reserve_type = rsv_param;
      cpu_rsv = rk_cpu_reserve_create(rs, &cpu_attr);
      if (cpu_rsv == 0) {
	printf("Cannot create rsv0 \n");
	rs_shutdown(rs);
      }
      printf("Creating rsv 0x%x \n", (int) cpu_rsv);
      /* Let's wait that the reserves are attached to their resource sets */
      while (rk_resource_set_get_cpu_rsv(rs) == 0);
      res = rk_resource_set_attach_process(rs, getpid());
      if (res != 0) {
	printf
	  ("rk_resource_set_attach_proces failed \n");
	rs_shutdown(rs);
      }
    }
#endif /* RESERVATION */
 

    start.tv_sec += 1;
    if (rt_make_periodic(&period, &start) != RK_SUCCESS) {
	perror("rt_make_periodic: period < MIN_PERIOD?\n");
	return 1;
    }

    printf("%s: waiting for data on port TCP %u\n",argv[0],SERVER_PORT);
    
    cliLen = sizeof(cliAddr);
    newSd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);
    if(newSd<0) {
      perror("cannot accept connection ");
      return ERROR;
    }

    rt_wait_for_start_time();

    history_round = 0;
    history_index = 0;
    while (1) {
 
      int new_round, new_index;
      
      fp = fopen("/proc/rk/energy", "r");


      // Read Data and Send it to the network

      // ignore the first line; which is the control data
      {
	int dump1, dump2, dump3;
	fscanf(fp, "%d %d %d", &dump1, &dump2, &dump3);
      }

      fscanf(fp, "%d %d %d", &max_energy_buffer, &new_round, &new_index);

      if ((new_round > history_round) && (new_index > history_index)) {
	printf("data overrun!!! \n");
      }



      for (i = 0; i < max_energy_buffer; i++) {
	fscanf(fp, "%d %d %d %d", &time[i], &freq[i], &volt[i], &power[i]);
      }

      if (!_start_done) {
	_start_done= 1;
	_starttime = time[new_index];
	history_index = new_index;
       
      }

      // send only the new data
      for (i = 0; i < max_energy_buffer; i++) {		
	bzero(buff, sizeof(buff));
	if (history_index == new_index)  break;
	sprintf(buff, "%d %d %d %d\n", (time[history_index]-_starttime), freq[history_index], volt[history_index], power[history_index]);
	n = send(newSd, buff, strlen(buff), 0);
	if(n<0) {
	  perror("cannot send data ");
	  close(sd);
	  return 1;
	  
	}
	
//	printf("%s: data%u sent %s\n'",argv[0], i++, buff);
	
	history_index++;
	if (history_index >= max_energy_buffer) history_index = 0;
      }
      
      history_index = new_index;
      history_round = new_round;

    
      fclose(fp);

      rt_wait_for_next_period();

    }
}
