/*
 * misc.c: Miscellaneous RK functions
 *
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <rk/rk_linux.h>
#include <rk/rk.h>
#include <rk/posix_timers.h>
#include <linux/timer.h>

extern int xyzzy;
extern void *sys_call_table[];
int __rk_resource_set_detach_process(rk_resource_set_t rs,
				     struct task_struct *tsk);
int rt_mutex_init(void);

int rk_has_timer = 0;

//extern struct timer_list rk_linux_timer;

extern void sys_rk_resource_set_create;
extern void sys_rk_resource_set_destroy;
extern void sys_rk_resource_set_attach_process;
extern void sys_rk_resource_set_detach_process;
extern void sys_rk_cpu_reserve_create;
extern void sys_rk_cpu_reserve_delete;
extern void sys_rk_cpu_reserve_ctl;
extern void sys_net_reserve_create;
extern void sys_net_reserve_ctl;
extern void sys_timer_create;
extern void sys_timer_delete;
extern void sys_timer_settime;
extern void sys_timer_gettime;
extern void sys_timer_getoverrun;
extern void sys_rk_resource_sets_get_num;
extern void sys_rk_resource_sets_get_list;
extern void sys_rk_cpu_reserves_get_num;
extern void sys_rk_cpu_reserves_get_list;
extern void sys_rk_cpu_reserve_get_attr;
extern void sys_rk_cpu_reserves_set_scheduling_policy;
extern void sys_rk_cpu_reserves_get_scheduling_policy;
extern void sys_rt_make_periodic;
extern void sys_rt_wait_for_start_time;
extern void sys_rt_wait_for_next_period;
extern void sys_rt_process_get_period;
extern void sys_rt_get_clock_frequency;
extern void sys_rk_resource_set_get_name;
extern void sys_rk_resource_set_set_name;
extern void sys_rk_resource_set_get_cpu_rsv;
extern void sys_rt_process_set_period;
extern void sys_rk_resource_set_get_num_procs;
extern void sys_rk_resource_set_get_proclist;
extern void sys_rt_mutex_create;
extern void sys_rt_mutex_destroy;
extern void sys_rt_mutex_trylock;
extern void sys_rt_mutex_lock;
extern void sys_rt_mutex_unlock;


extern void sys_rk_disk_reserve_create;
extern void sys_rk_disk_reserve_delete;
extern void sys_rk_disk_reserve_get_attr;
extern void sys_rk_reserve_update_account;
extern void sys_rk_reserve_quota_query;
extern void sys_rk_reserve_wait_on_quota;
extern void sys_css_disk_cpu_reserve_create;
extern void sys_rk_cleanup;
extern void sys_rk_cpu_reserve_dummy_create;

extern void sys_rt_get_scheduling_error;

extern void sys_rk_disk_set_css;

extern int sys_rk_blocked;

extern void sys_rk_resource_set_attach_socket;
extern void sys_rk_resource_set_detach_socket;
extern void sys_rk_rnet_reserve_create;
extern void sys_rk_rnet_reserve_ctl;
//Sourav
extern void sys_rk_cpu_reserve_get_history;
extern void sys_rk_net_reserve_get_history;

extern rk_reserve_t sys_rk_cpu_ceiling_reserve_create;
extern int sys_rk_attach_ceiling_rs;
extern int sys_rk_detach_ceiling_rs;

void rk_init(void);
void rk_cleanup(void);
void rk_proc_cleanup(void);
void rk_disable_isr(void);
void rk_disable_schedule_cpu(void);
void rk_task_cleanup(struct task_struct *);
void rk_fork(struct task_struct *);
void rk_timer_destroy(rk_timer_t);
void rk_timer_remove(rk_timer_t);
void rk_enable_schedule_cpu(void);
void rk_enable_isr(void);
void rk_disable_hook_disk_reserve(void);
extern int rk_loaded;
int rk_count = 0;

//#ifdef THREADED_NET
extern void rcv_net_processing_init(void);
extern void rcv_net_processing_cleanup(void);

//#endif

#define NUM_SYSTEM_CALLS 460




//#define NUM_SYSTEM_CALLS 460

asmlinkage void sys_rk_inherit_mode(int mode)
{
    current->rk_inherit = mode;
}

int init_module(void)
{
    int i;

    /* TODO: Check for RTAI and refuse to load if present */

    /* Insert system calls */
    for (i = 402; i <= NUM_SYSTEM_CALLS; i++)
	if (sys_call_table[i] != sys_call_table[0] && sys_call_table[i])
	    break;
    if (i != NUM_SYSTEM_CALLS + 1) {
	printk(KERN_ERR "RK system calls already in use.\n");
	return -EBUSY;
    }
    rk_task_cleanup_hook = rk_task_cleanup;
    rk_fork_hook = rk_fork;
    rt_adjbaseprio_hook = rt_adjbaseprio;

    /* Setup Resource Kernel */
    rt_mutex_init();
    rk_init();
    rk_enable_schedule_cpu();
    rk_enable_isr();

    /* Enable kernel hooks */
    rk_loaded = 1;

    sys_call_table[402] = &sys_rk_resource_set_create;
    sys_call_table[403] = &sys_rk_resource_set_destroy;
    sys_call_table[404] = &sys_rk_resource_set_attach_process;
    sys_call_table[405] = &sys_rk_resource_set_detach_process;
    sys_call_table[406] = &sys_rk_cpu_reserve_create;
    sys_call_table[407] = &sys_rk_cpu_reserve_delete;
    sys_call_table[408] = &sys_rk_cpu_reserve_ctl;
    sys_call_table[409] = &sys_net_reserve_create;
    sys_call_table[410] = &sys_net_reserve_ctl;
    sys_call_table[411] = &sys_timer_create;
    sys_call_table[412] = &sys_timer_delete;
    sys_call_table[413] = &sys_timer_settime;
    sys_call_table[414] = &sys_timer_gettime;
    sys_call_table[415] = &sys_timer_getoverrun;
    sys_call_table[416] = &sys_rk_resource_sets_get_num;
    sys_call_table[417] = &sys_rk_resource_sets_get_list;
    sys_call_table[418] = &sys_rk_cpu_reserves_get_num;
    sys_call_table[419] = &sys_rk_cpu_reserves_get_list;
    sys_call_table[420] = &sys_rk_cpu_reserve_get_attr;
    sys_call_table[421] = &sys_rk_cpu_reserves_set_scheduling_policy;
    sys_call_table[422] = &sys_rk_cpu_reserves_get_scheduling_policy;
    sys_call_table[423] = &sys_rt_make_periodic;
    sys_call_table[424] = &sys_rt_wait_for_start_time;
    sys_call_table[425] = &sys_rt_wait_for_next_period;
    sys_call_table[426] = &sys_rt_process_get_period;
    sys_call_table[427] = &sys_rt_get_clock_frequency;
    sys_call_table[428] = &sys_rk_resource_set_get_name;
    sys_call_table[429] = &sys_rk_resource_set_get_cpu_rsv;
    sys_call_table[430] = &sys_rt_process_set_period;
    sys_call_table[431] = &sys_rk_resource_set_get_num_procs;
    sys_call_table[432] = &sys_rk_resource_set_get_proclist;
    sys_call_table[433] = &sys_rk_inherit_mode;
    sys_call_table[434] = &sys_rt_mutex_create;
    sys_call_table[435] = &sys_rt_mutex_destroy;
    sys_call_table[436] = &sys_rt_mutex_trylock;
    sys_call_table[437] = &sys_rt_mutex_lock;
    sys_call_table[438] = &sys_rt_mutex_unlock;
    sys_call_table[439] = &sys_rk_resource_set_set_name;
    sys_call_table[440] = &sys_rk_disk_reserve_create;
    sys_call_table[441] = &sys_rk_disk_reserve_delete;
    sys_call_table[442] = &sys_rk_disk_reserve_get_attr;
    sys_call_table[443] = &sys_rk_reserve_update_account;
    sys_call_table[444] = &sys_rk_reserve_quota_query;
    sys_call_table[445] = &sys_rk_reserve_wait_on_quota;
    sys_call_table[446] = &sys_css_disk_cpu_reserve_create;
    sys_call_table[447] = &sys_rk_cleanup;
    sys_call_table[448] = &sys_rk_cpu_reserve_dummy_create;
    sys_call_table[449] = &sys_rt_get_scheduling_error;
    sys_call_table[450] = &sys_rk_disk_set_css;

    sys_call_table[451] = &sys_rk_blocked;
    sys_call_table[452] = &sys_rk_resource_set_attach_socket;
    sys_call_table[453] = &sys_rk_resource_set_detach_socket;
    sys_call_table[454] = &sys_rk_rnet_reserve_create;
    sys_call_table[455] = &sys_rk_rnet_reserve_ctl;
    sys_call_table[456] = &sys_rk_attach_ceiling_rs;
    sys_call_table[457] = &sys_rk_cpu_ceiling_reserve_create;
    sys_call_table[458] = &sys_rk_detach_ceiling_rs;
    sys_call_table[459] = &sys_rk_cpu_reserve_get_history;
    sys_call_table[460] = &sys_rk_net_reserve_get_history;


    /* Create default and idle resource_set */
    {
	rk_reserve_t cpu_reserve_dummy_create(rk_resource_set_t rs,
					      time_t duration);
	extern rk_resource_set_t rk_default_resource_set;
	extern rk_resource_set_t rk_idle_resource_set;

	rk_default_resource_set = rk_resource_set_create("default");
	cpu_reserve_dummy_create(rk_default_resource_set,
				 DEFAULT_PERIOD_SEC);
#ifdef APPLE_DEBUG
	printk("create default resource %x \n",
	       (unsigned int) rk_default_resource_set);
#endif				/* APPLE_DEBUG */
	rk_idle_resource_set = rk_resource_set_create("idle");
	cpu_reserve_dummy_create(rk_idle_resource_set, IDLE_PERIOD_SEC);
	/* Attach idle resource set to the idle task */
#if 0
	resource_set_attach_process(rk_idle_resource_set,
				    export_idle_task(smp_processor_id()));
#endif
#ifdef APPLE_DEBUG
	printk("create idle resource %x \n",
	       (unsigned int) rk_idle_resource_set);
#endif				/* APPLE_DEBUG */
    }

    //#ifdef THREADED_NET
    rcv_net_processing_init();
    //#endif
    return 0;
}

void cleanup_module(void)
{
    int i;
    for (i = 402; i <= NUM_SYSTEM_CALLS; i++)
#ifdef __i386__
	sys_call_table[i] = sys_call_table[0];
#elif defined(__powerpc__)
    sys_call_table[i] = NULL;
#else
#error I do not know what empty system calls look like on your architecture
#endif
	rk_cleanup();
    rk_disable_isr();
    rk_disable_schedule_cpu();
    rk_disable_hook_disk_reserve();
    rk_proc_cleanup();
    rk_task_cleanup_hook = NULL;
    rk_fork_hook = NULL;
    rt_adjbaseprio_hook = NULL;

    //#ifdef THREADED_NET
    rcv_net_processing_cleanup();
    //#endif
}

/* These are in this file because linux/module.h doesn't like
	being included from more than one file per module */
void rk_inc_use_count(void)
{
    MOD_INC_USE_COUNT;
}

void rk_dec_use_count(void)
{
    MOD_DEC_USE_COUNT;
}

void rk_task_cleanup(struct task_struct *ts)
{
    if (ts->posix_timers) {
	int i;
	for (i = 0; i < MAXPOSIXTIMERS; i++) {
	    if (ts->posix_timers[i]) {
		rk_timer_remove(ts->posix_timers[i]->rkt);
		rk_timer_destroy(ts->posix_timers[i]->rkt);
		free(ts->posix_timers[i]);
		rk_disable();
	    }
	}
	free(ts->posix_timers);
	ts->posix_timers = NULL;
    }

    if (ts->periodicType == PERIODIC) {
	rk_timer_remove(ts->period_timer);
	rk_timer_destroy(ts->period_timer);
    }

#if 0

    /***********Sourav: Old Stuff: a task can be attached to multiple resource 
		sets at the same time **************/

    if (ts->rk_resource_set)
      {
	
	__rk_resource_set_detach_process(ts->rk_resource_set, ts);
	
      }

#endif

    /*************Sourav : New Stuff: detach ALL the resource sets from the task **************/

    {struct resource_set_list *list, *rs_list;
    struct list_head *ptr, *head;
    struct rk_resource_set *rk_resource_set;
    
    list = &(ts->rs_list);

    /* no resource set attached */
    if (list->resource_set_list.next == NULL)
      {
	
	INIT_LIST_HEAD(&(ts->rs_list.resource_set_list));
	return;
      }
    
	
    head = &((&ts->rs_list)->resource_set_list);

    for (ptr = head->next;
	 ptr != head; ptr = ptr->next) {
	/* get the resource_set_list entry */

      
	rs_list =
	    list_entry(ptr, struct resource_set_list, resource_set_list);
	rk_resource_set = rs_list->rk_resource_set;
	/* detach resource set */
	{
	  
	    __rk_resource_set_detach_process(rk_resource_set, ts);
	}


    }


    }
    
}

void rk_fork(struct task_struct *ts)
{

    struct k_sigaction *ka;

    /* set/clear fields that are not persistent across fork() */
    ts->rk_resource_set = NULL;
    ts->num_posix_timers = 0;
    ts->posix_timers = NULL;

    ts->periodicType = 0;
    ts->period_timer = NULL;
    ts->deadline_timer = NULL;
    ts->rt_deadline_handler_pid = -1;
    ts->last_start.tv_sec = 0;
    ts->last_start.tv_nsec = 0;
    ts->startTime.tv_sec = 0;
    ts->startTime.tv_nsec = 0;

    INIT_LIST_HEAD(&ts->mutexes);
    

    if (current->rk_inherit && current->rk_resource_set)
      {
	resource_set_attach_process(current->rk_resource_set, ts);
      }

    /* PCP */
	/*
    ts->rs_ceiling_vector = NULL;
    ts->rt_ceiling_priority_index = 0;
*/

    /* The first RT signal is used for notifying enforcements...
       By default, it must be ignored
       Luca
     */
    /*ka = &ts->sig->action[0];
    ka += SIGRTMIN + ENFORCE_SIGNAL;
    */
/*    ka += SIGRTMIN; */
    //ka->sa.sa_handler = SIG_IGN;
}
