/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*			program developed by Luca Abeni
 *					luca@sssup.it
 *					http://hartik.sssup.it/~luca
 */

#include<stdio.h>

#define VIDEO

#ifdef VIDEO
#include<curses.h>
#endif

#include <rk/posix_timers.h>
#include <arch/local.h>

#include "qos.h"
#include "req.h"
#include "adj.h"

extern TASK mpbody(WORD id);
int ac;
char *av[10];

DWORD times[10000];

DWORD qos_time(void)
{
    struct timespec t;

    clock_gettime(CLOCK_REALTIME, &t);

    return t.tv_sec * 1000000 + t.tv_nsec / 1000;
}

int main(int argc, char *argv[])
{
    struct qparm t;
    struct qmparm initparm;
    ID qt1, qt2;
    char name[80];
    int i;

    ac = argc;
    for (i = 0; i < argc; i++) {
	av[i] = argv[i];
    }

cprintf("Goin' to start it\n");
    initparm.psu = 0.1;
    initparm.rmu = 0.9;		/* RM upper bound = 0.9 */
    initparm.psq = 1000;
    if (qman_init(&initparm) < 0) {
	printf("Error initializing the QoS manager...\n");
	exit(-1);
    }
cprintf("ok....\n");
    setreq(&adjactions);
    printf("Init Done!!!\n");
    t.wcet = 3000;
    t.per = 66000;
    t.reduce = 0;
    t.w = 1;
    t.arg = 0;
    sprintf(name, "Task1");
    t.name = name;
    t.body = mpbody;

    qt1 = qset_addtask(&t);
    if (qt1 == 0) {
	printf("QoS Task creation failed...\n");
	exit(-1);
    }
//sleep(5);
    t.wcet = 3000;
    t.per = 33000;
    t.reduce = 0;
    t.w = 5;
    t.arg = 1;
    sprintf(name, "Task2");
    t.name = name;
    t.body = mpbody;

    qt2 = qset_addtask(&t);
    if (qt2 == 0) {
	printf("QoS Task creation failed...\n");
	exit(-1);
    }
    cprintf("And 2....\n");

    printf("Waiting...\n");
    for (;;);
    sleep(20);

    exit(0);
}
