/*
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <linux/config.h>
#include <linux/module.h>
#include <linux/stddef.h>
#include <asm/spinlock.h>
#include <asm/ptrace.h>


/**Network **/
#include <linux/socket.h>
#include <net/sock.h>
#include <net/pkt_sched.h>
int rk_in_intr=0;
int rk_loaded=0;
spinlock_t rk_lock=SPIN_LOCK_UNLOCKED;
EXPORT_SYMBOL(rk_loaded);
EXPORT_SYMBOL(rk_lock);
EXPORT_SYMBOL(rk_in_intr);

/*
 * Hooks
 */
struct task_struct;

/* arch/i386/kernel/irq.h */
void	(*rk_kernel_intr_in_hook)(void)=NULL; 
/* arch/i386/kernel/entry.S */
void	(*rk_restore_all_hook)(struct pt_regs regs)=NULL;
int	(*rk_ret_with_reschedule_hook)(struct pt_regs regs)=NULL;
/* kernel/sched.c */
void	(*rk_schedule_hook)(struct task_struct *, struct task_struct *)=NULL;
void	(*rt_adjbaseprio_hook)(struct task_struct *, int, int)=NULL;
/* kernel/exit.c */
void  (*rk_task_cleanup_hook)(struct task_struct *)=NULL;
/* kernel/fork.c */
void	(*rk_fork_hook)(struct task_struct *)=NULL;
/* fs/buffer.c */
void (*rk_disk_reserve_hook)(struct task_struct *, struct buffer_head *)=NULL;
/* mm/filemap.c */
int (*rk_disk_readahead_max_hook)(struct inode *, struct task_struct *)=NULL;  
/* mm/filemap.c */
int (*rk_disk_realtime_req_hook)(struct task_struct *)=NULL;
#ifdef DISK_OVH_MEASURE
/* fs/read_write.c */
void (*rk_tick2nanosecond_hook)(long, long *)= NULL;
#endif DISK_OVH_MEASURE

EXPORT_SYMBOL(rk_kernel_intr_in_hook);
EXPORT_SYMBOL(rk_restore_all_hook);
EXPORT_SYMBOL(rk_ret_with_reschedule_hook);
EXPORT_SYMBOL(rk_schedule_hook);
EXPORT_SYMBOL(rk_task_cleanup_hook);
EXPORT_SYMBOL(rk_fork_hook);
EXPORT_SYMBOL(rt_adjbaseprio_hook);
EXPORT_SYMBOL(rk_disk_reserve_hook);
EXPORT_SYMBOL(rk_disk_readahead_max_hook);
EXPORT_SYMBOL(rk_disk_realtime_req_hook);
#ifdef DISK_OVH_MEASURE
EXPORT_SYMBOL(rk_tick2nanosecond_hook);
#endif DISK_OVH_MEASURE
EXPORT_SYMBOL(qdisc_run_queues);
EXPORT_SYMBOL(ptype_base);

extern struct packet_type *ptype_all;
EXPORT_SYMBOL(ptype_all);

//EXPORT_SYMBOL(dev_base);

extern atomic_t netdev_rx_dropped;
EXPORT_SYMBOL(netdev_rx_dropped);
int rk_rcv_pkt_dummy (struct sk_buff_head *head, struct sk_buff *skb)
{
  return (1);
}
int (*rk_netif_rx_hook)(struct sk_buff_head *, struct sk_buff *) = rk_rcv_pkt_dummy;

void dummy_process_pkt (struct sk_buff_head *back_list,struct packet_type *ptype_all, int * rk_recv_processing)
{
  *rk_recv_processing = 0;

}

void (*rk_process_pkt_hook) (struct sk_buff_head *, struct packet_type *, int * ) = dummy_process_pkt;
void (*rk_resource_bind_hook)(struct task_struct *, struct socket *) = NULL;

extern struct sock *tcp_v4_lookup(u32 saddr, u16 sport, u32 daddr, u16 dport, int dif);
extern struct sock *udp_v4_lookup(u32 saddr, u16 sport, u32 daddr, u16 dport, int dif);


void (*bh_attach_rs_hook)(void) = NULL;
void (*bh_detach_rs_hook)(void) = NULL;

EXPORT_SYMBOL(udp_v4_lookup);
EXPORT_SYMBOL(tcp_v4_lookup);
EXPORT_SYMBOL(rk_netif_rx_hook);
EXPORT_SYMBOL(rk_rcv_pkt_dummy);
EXPORT_SYMBOL(rk_process_pkt_hook);
EXPORT_SYMBOL(dummy_process_pkt);
EXPORT_SYMBOL(rk_resource_bind_hook);
EXPORT_SYMBOL(bh_attach_rs_hook);
EXPORT_SYMBOL(bh_detach_rs_hook);
