/*
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <linux/sys.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/measure.h>
#include <linux/module.h>

MeasureOp *current_measure_hook = NULL;
EXPORT_SYMBOL(current_measure_hook);
// It's nothing wrong here. Everything have been moved to 
// include/linux/measure.h.
#if 0
int sys_measure_register(int pid,int cmd,int data)
{
  if (current_measure_hook&&current_measure_hook->reg)
    return current_measure_hook->reg(pid,cmd,data);
  return -ENOSYS;
}

int sys_measure_getinfo(MEASURE *info)
{
  if (current_measure_hook&&current_measure_hook->getinfo)
    return current_measure_hook->getinfo(info);
  return -ENOSYS;
}
#endif

void measure_begin(int no)
{
  if (current_measure_hook&&current_measure_hook->begin_measure)
    current_measure_hook->begin_measure(no);
}


void measure_end(void)
{
  if (current_measure_hook&&current_measure_hook->end_measure)
    current_measure_hook->end_measure();
}

void measure_syscall(int no)
{
  if (current_measure_hook&&current_measure_hook->syscall)
    current_measure_hook->syscall(current->pid,no);
}
