/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*Initiator program */


#include "inet.h"
#define REPLIER_UDP_PORT 9100 
#define INITIATOR_UDP_PORT 8100 

int main(argc, argv)
int argc;
char *argv[];
{
  int sockfd;
  struct sockaddr_in  cli_addr, serv_addr;
  FILE *fp;

  pname = argv[0];

 fp = fopen("echo_file.dat","r");
 if ( fp == NULL)
     perror("err opening file");

bzero ((char *) &serv_addr, sizeof(serv_addr));

serv_addr.sin_family = AF_INET;
serv_addr.sin_addr.s_addr = inet_addr(REPLIER_HOST_ADDR);
serv_addr.sin_port = htons (REPLIER_UDP_PORT);


if (( sockfd = socket (AF_INET, SOCK_DGRAM, 0)) < 0)

   perror("initiator:err opening socket");

   bzero((char *) &cli_addr, sizeof(cli_addr));
   cli_addr.sin_family = AF_INET;
   cli_addr.sin_addr.s_addr = inet_addr(INITIATOR_HOST_ADDR);
   cli_addr.sin_port = htons (INITIATOR_UDP_PORT);
   if (bind(sockfd, (struct sockaddr *) &cli_addr, sizeof(cli_addr)) < 0)
     perror("initiator:can't bind loc addr");
    
   dg_cli(fp, sockfd,(struct sockaddr *) &serv_addr, sizeof(serv_addr));

   close(sockfd);
   return 0;
}
