/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*File : inet.c */


#include "inet.h"
 
 
void
Usleep(unsigned int nUsecs)
{
   struct  timeval tval;

    tval.tv_sec = nUsecs / 1000000;
    tval.tv_usec = nUsecs % 1000000;
    while(select(0, NULL, NULL, NULL, &tval) == -1) {
        if(errno == EINTR) {
            break;
        } else {
            perror("select() in Usleep()");
	    exit(0);
        }
    }
}



void dg_echo (int sockfd,struct sockaddr *pcli_addr,int maxclilen) { 
 
  int clilen,m;
  char mesg[MAXMESG];
  
 
clilen = maxclilen;

 

 m = recvfrom( sockfd, mesg, MAXMESG, 0, pcli_addr, &clilen); 
 
 if (m < 0) perror("recvfrom err"); 


printf("mesg = %s\n", mesg); 


while (1) { 

       
   sendto(sockfd, mesg, m, 0, pcli_addr, clilen);

   //Usleep(1000);
  
  
       }
       
}




void dg_cli(fp, sockfd, pserv_addr, servlen)

FILE *fp;
int sockfd;
struct sockaddr *pserv_addr;
int servlen;
{
int n;
char sendline[MAXLINE], recvline[MAXLINE +1];


printf("serv len = %x\n", servlen);


/*****************Sender-Receiver hand-shaking could be introduced here***************/


/*****************************************************************************/

while (fgets(sendline, MAXLINE, fp) != NULL)
  {
   n = strlen(sendline);
   
   
    printf("sendline %s\n", sendline);
    printf("size of line %d\n", strlen(sendline));
 
    if (sendto(sockfd, sendline, n, 0, pserv_addr, servlen) != n)  
      perror("dg_cli:sendto err1");  
    printf ("%s sent\n", sendline); 

while (1){


 n = recvfrom(sockfd, recvline, MAXLINE, 0, pserv_addr, &servlen); 
  
//printf(" %s\n", recvline); 

  
if (n < 0)
	  perror("dg_cli:recvfrom error");


	recvline[n] = 0;




   } 

  }


}



