/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*Echo replier program */


#include "inet.h"
#define INITIATOR_UDP_PORT 8100 
#define REPLIER_UDP_PORT 9100 


int main( int argc, char **argv);

rk_resource_set_t rs;

int 
main( int argc, char **argv)
{
  int sockfd;
  struct sockaddr_in  cli_addr, serv_addr;
  rk_resource_set_t rs;
  rk_reserve_t net_rsv;
  net_reserve_attr_data_t attr;

  struct timespec t;
  size_t c;
  
    char name[16];


 if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
  
  perror("echo_replier:can't open socket");

 bzero ((char *) &serv_addr, sizeof(serv_addr));
 serv_addr.sin_family = AF_INET;
 serv_addr.sin_addr.s_addr = inet_addr(REPLIER_HOST_ADDR);
 serv_addr.sin_port  = htons(REPLIER_UDP_PORT);

 bzero((char *) &cli_addr, sizeof(cli_addr));
 cli_addr.sin_family = AF_INET;
 cli_addr.sin_addr.s_addr = inet_addr(INITIATOR_HOST_ADDR);
 cli_addr.sin_port = htons (INITIATOR_UDP_PORT);



if (bind (sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)

     perror("echo_replier: can't bind loc addr");

 
 sprintf(name, "Rset %d", getpid());

#ifdef RK_NET_RSV
  rs = rk_resource_set_create(name);

  /*old : rs = rk_resource_set_create(); */

 printf("Resource set created: (0x%x)=(%d)\n", (int)rs, (int)rs);

{
    rk_reserve_param_data_t p; /* specify sch_mode, enforcement, replenishment */
    c = 2000; /* Network : load amount in bytes */
    t.tv_sec = 1;
    t.tv_nsec = 100*1000*1000;                  /* Period: 1 sec        */ 

    p.enf_mode = RSV_HARD;                        /* enum in rk.h -> check =0x1 */

    p.sch_mode = p.rep_mode = RSV_HARD; 

    
 attr.amount = 40000;
  attr.period.tv_sec = 0;
  attr.period.tv_nsec = 100*1000*1000;
  attr.deadline.tv_sec = 1;
  attr.deadline.tv_nsec = 0;

  attr.start_time.tv_sec = 0;
  attr.start_time.tv_nsec = 0;
  attr.blocking_time.tv_sec = 0;
  attr.blocking_time.tv_nsec = 0;

  attr.reserve_type.enf_mode = RSV_HARD;
  attr.reserve_type.sch_mode = attr.reserve_type.rep_mode = RSV_HARD;
 
  attr.socket_fd = sockfd;
  net_rsv = rk_net_reserve_create(rs, &attr);
  if (net_rsv == NULL) {
	  printf("Net reserve creation failed!!!\n");
	  close(sockfd);
	  exit(-1);
  }
  printf("Net reserve create: %p\n", net_rsv);



  }


/* c = 20000;

   t.tv_sec = 0;
   t.tv_nsec = 100*1000*1000;

   p.enf_mode = RSV_FIRM;
 
   p.sch_mode = p.rep_mode = RSV_SOFT;
*/

 //  net_rsv = rk_net_reserve_create(rs, c, &t, &p, sockfd);

 if (net_rsv != NULL)

   printf("net reserve created: %x\n", (int)net_rsv);


#endif // RK_NET_RSV
 
/*pid = getpid();

   attach_process = rk_resource_set_attach_process(rs,pid);

   if (attach_process == 0)
   printf("process has been successfully attached to the resource set");

   else 
   printf("attachment failure\n");
 */ 

dg_echo (sockfd, (struct sockaddr *) &cli_addr, sizeof(cli_addr));
return 0;

}




