/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <signal.h>

rk_resource_set_t rs;

#define KB 1024
void 
print_usage(char *cmdname){
  printf("Usage: %s <resource_set> \n", cmdname);
}

int 
main(int argc, char *argv[]){

  if (argc != 2){
    print_usage(argv[0]);
    return -1;
  }
  
  if ((rs = (rk_resource_set_t)atoi(argv[1])) == NULL) {
    fprintf(stderr, "%s: could not create resource set.  TimeSys RK module loaded?\n", argv[0]);
    exit(-1);
  }

  printf("Resource Set (0x%x)=(%d) DISK Reserve destroyed\n",
	 (int)rs, (int)rs);
  
  return rk_disk_reserve_delete(rs);
}
