/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*			program developed by Luca Abeni
 *					luca@sssup.it
 *					http://hartik.sssup.it/~luca
 */
#define KB 1024
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <rk/rk.h>
#include <rk/css.h>
#include <rk/posix_timers.h>

int C1,T1;
rk_resource_set_t rs1;

unsigned long int firstime;
struct timespec fnow;



extern int mpbody(unsigned short int id);
int ac;
char *av[10];

unsigned int times[10000];

unsigned int qos_time(void)
{
    struct timespec t;

    clock_gettime(CLOCK_REALTIME, &t);

    return t.tv_sec * 1000000 + t.tv_nsec / 1000;
}


/* Destroy the resource sets... end exit!!! */
void shutdown(int i)
{
    int res;

    res = rk_resource_set_destroy(rs1);
    if (res != 0) {
	printf("rk_resource_set_destroy failed destroying RS %p", rs1);
    }
    printf("Everything is finished... I am going to exit!\n");
    exit(0);
}


int main(int argc, char *argv[])
{
    char name[80];
    rk_reserve_param_data_t p;
    struct timespec t;
    css_disk_cpu_reserve_attr_data_t css_attr;    

    if (argc < 3) {
      printf("RSV for aperiodic FS request  \n");
      printf("Usage: %s [size KB] [T ms]  \n", argv[0]);
      exit(1);
    }
    strcpy(name, "dummyFS"); /* resource set name */
    C1 = atoi(argv[1]);/* reserve size in KB */
    T1 = atoi(argv[2]);/* reserve period time in ms */

    /* create resource sets */
    rs1 = rk_resource_set_create(name);
    if (((int) rs1 == -1) || (rs1 == NULL)) {
	printf("Cannot create resource set 1!!!\n");
	exit(-1);
    }

    /* And now, the reserves... */
    clock_gettime(CLOCK_REALTIME, &fnow);
    firstime = fnow.tv_nsec / 1000000 + fnow.tv_sec * 1000;

    t.tv_sec = T1 / 1000, t.tv_nsec = (T1 % 1000) * 1000 * 1000;

    p.enf_mode = p.sch_mode = p.rep_mode = RSV_SOFT;
    //p.enf_mode = p.sch_mode = p.rep_mode = RSV_HARD;

    css_attr.compute_bf.tv_sec = css_attr.compute_bf.tv_nsec = 0;
    css_attr.compute_af.tv_sec = css_attr.compute_af.tv_nsec = 0;
    /* speed about 1.4 Mbps */
    css_attr.size = C1 * KB;
    css_attr.period = t;
    css_attr.deadline = css_attr.period;
    css_attr.blocking_time.tv_sec =css_attr.blocking_time.tv_nsec=(long int)0;
    memcpy(&css_attr.start_time, &fnow, sizeof(struct timespec));
    css_attr.start_time.tv_sec += 1;
    css_attr.reserve_type = p;
    
    if (css_disk_cpu_reserve_create(rs1, &css_attr)) {
      printf("css create failed! \n");
      shutdown(1);
    }
    /* Let's wait that the reserves are attached to their resource sets */
    while (rk_resource_set_get_cpu_rsv(rs1) == 0);
        
    printf("Done...\n");

    /* And now, waiting for signal */
    signal(SIGINT, shutdown);    
    while(1);
    /* ...and destroy the resource sets!!! */
    shutdown(1);
    return 0;
}
