/*                               -*- Mode: C -*- 
 * cwsessionsif.h -- Clockwise session manager interface file.
 * 
 * Author          : 
 * Created On      : Sun Jan 31 13:05:53 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Thu Apr 22 15:10:09 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#ifndef _CWSESSIONSIF_H_
#define _CWSESSIONSIF_H_

#include <cwif.h>

#define CWSESSIONS 	"/dev/cwsessions"
#define CWS_IOCTL(r, a)	(('c' << 24) | ('s' << 16) | (((r) & 0xFF) << 8) | \
                         ((a) & 0xFF))
#define CWS_IOCTLMASK	0xFFFFFF00
#define CWS_NEW		CWS_IOCTL(0, 0)		/* Get a new session handle */
#define CWS_GETSTAMP(a)	CWS_IOCTL(1, (a))	/* Get the current tstamp */
#define CWS_SETSTAMP	CWS_IOCTL(2, 0)		/* Set the current tstamp */
#define CWS_ATTACH(a)	CWS_IOCTL(3, (a))	/* Attach a substream */
#define CWS_PAUSE(a)	CWS_IOCTL(4, (a))	/* Pause a subsession */
#define CWS_RESUME(a)	CWS_IOCTL(5, (a))	/* Resume a subsession */
#define CWS_CONTINUE(a)	CWS_IOCTL(6, (a))	/* Wait for continuation */
#define CWS_INDEX(a)	CWS_IOCTL(7, (a))	/* Return all indexes */

#define NUMSSESSIONS	20

typedef uint8_t cws_handle_t;

typedef struct {
  uint32_t	i_frame;	/* Frame number */
  Time_t	i_tc;		/* Time code of frame */
  pid_t		i_pid;		/* Owner process */
} cws_index_t;

typedef struct {
  Time_t 	t_set;		/* When was the time code set? */
  Time_t 	t_tc;		/* The time code itself */
} cws_tstamp_t;

typedef struct {
  cws_handle_t	ts_handle;	/* The session handle */
  cws_tstamp_t	ts_ts;		/* The time stamp to set */
} cws_ststamp_t;

typedef enum { SessionRunning, SessionPaused } sstate_t;

#endif

