/*                               -*- Mode: C -*- 
 * cwnet.h -- Network protocol messages.
 * 
 * Author          : 
 * Created On      : Thu Jun 17 16:54:45 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Fri Sep 17 13:25:57 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#ifndef _CWNET_H
#define _CWNET_H

#include <cwif.h>

typedef struct {
  Time_t	fr_ts;		/* When to play frame (nanoseconds) */
  loff_t	fr_offs;	/* Offset of frame in dynpar */
  uint32_t	fr_size;	/* Size of frame */
  uint64_t	fr_fnum;	/* Client data */
} perframe_t;

typedef enum { CWForward, CWBackward } cwdirection_t;

typedef struct {
  cwdirection_t	frs_dir;	/* Play direction */
  uint32_t	frs_nfrs;	/* Number of frame requests to follow */
  perframe_t	frs_fr[1];	/* Frame requests */
} frames_t;

typedef struct {
#define MAXDPNAME	256
  char		ini_dpname[MAXDPNAME];	/* Dynpar to use */
  uint32_t	ini_bsize;	/* Block size */
  uint32_t	ini_bw;		/* Bandwidth */
  uint32_t	ini_nbufs;	/* Number of I/O buffers */
  loff_t	ini_offs;	/* Initial offset */
} init_t;

typedef struct {
  uint32_t	req_type;	/* Request type */
  uint32_t	req_errno;	/* Request success? */
#define CWREQ_MAGIC	0x35145772
  uint32_t	req_magic;	/* Request magic for the client when
				   it is out of sync */
  union {
    init_t	u_init;		/* Initialization structure */
    frames_t	u_frames;	/* A request for frames */
    perframe_t	u_data;		/* A single frame */
  } req_u;
} cwreq_t;

#define CWREQ_NONE	0	/* Message contains error only */
#define CWREQ_INIT	1	/* Message contains initialization data */
#define CWREQ_FRAMES	2	/* Message contains a request for frames */
#define CWREQ_DATA	3	/* Message contains data */

#define ATMNETSIZE	(16 * K)
#define NPLAYLIST	128

typedef enum { CWRecord, CWPlayback } cwmode_t;

typedef struct {
  char		*m_av;		/* Audio or video */
  char 		*m_dpname;	/* Name of dynpar */
  char 		*m_idxname;	/* Name of index file */
  char		*m_bsize;	/* Block size to use */
  char		*m_bw;		/* Bandwidth to use */
  char		*m_preload;	/* Number of preload buffers to use */
} cwmedia_t;

extern int cw_establish(char *server, char *lrvpivci, char *rrvpivci,
			char *lsvpivci, char *rsvpivci,
			char *dpname, uint32_t bsize, uint32_t bw, 
			uint32_t nbufs, loff_t offs, cwmode_t mode,
			void **vc);
extern int cw_close(void *vc);
extern int cw_playlist(void *vc, uint32_t nframes, perframe_t *pfs,
		       cwdirection_t direction);
extern int cw_getdata(void *vc, uint64_t *fnum, uint8_t *buf, uint32_t size);
extern int cw_senddata(void *vc, uint8_t *buf, uint32_t size);
extern int cw_parseindex(char *fname, cwmedia_t **cwmedia);
extern void cw_freeindex(int nstreams, cwmedia_t *cwmedia);
extern int cw_vpivci(char *source, char *dest, char *av, 
		     char **lvpivci, char **rvpivci);

#endif
