/*                               -*- Mode: C -*- 
 * cwlib.h -- Library to interface to Clockwise dynamic partitions.
 * 
 * Author          : 
 * Created On      : Tue Aug  3 08:43:21 1999
 * Last Modified By: 
 * Last Modified On: Tue Aug  3 08:54:25 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#ifndef _CWLIB_H
#define _CWLIB_H

typedef struct {
  char		*su_servername;		/* Clockwise server name */
  uint32_t	su_bsize;		/* Clockwise buffer size to use */
  uint32_t	su_bw;			/* Clockwise bandwidth to use */
  loff_t	su_soffs;		/* Clockwise dp start offset */
  int		su_pf;			/* Protocol family */
} cw_setupargs_t;

typedef struct {
  int	cw_read(loff_t offs, uint32_t size, uint8_t *buf);
  int	cw_write(loff_t offs, uint32_t size, uint8_t *buf);
  int	cw_close();
} cw_methods_t;

extern int cw_setup(cw_setupargs_t *args, cw_methods_t *methods);

#endif

