/*                               -*- Mode: C -*- 
 * info.h -- Info include file.
 * 
 * Author          : 
 * Created On      : Tue Apr 20 08:39:34 1999
 * Last Modified By: 
 * Last Modified On: Mon Aug 16 08:29:10 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#ifndef _INFO_H
#define _INFO_H

struct _info_t;

typedef struct _info_t {
  struct _info_t
                *i_next;	/* Next button */
  Display	*i_display;	/* Owner display */
  Window	i_win;		/* Owner window */
  GC		i_gc;		/* Graphical context */
  XFontStruct 	*i_mf;		/* Font information */
  Pixmap	i_stipple;	/* Stipple */
  int		i_x;		/* Relative location of button */
  int		i_y;		/* ditto */
  int		i_width;	/* Width of button */
  int		i_height;	/* Height of button */
  unsigned long	i_fg;		/* Foreground color */
  unsigned long	i_bg;		/* Background color */
  unsigned long	i_hi;		/* High color */
  unsigned long	i_lo;		/* Low color */
  int		i_active;	/* Box active? */
  char		*i_info;	/* Box information */
} info_t;

extern info_t *i_new(Display *display, Window win, GC gc, XFontStruct *mf,
		     Pixmap stipple, int x, int y, int width, int height, 
		     unsigned long fg, unsigned long bg, 
		     unsigned long hi, unsigned long lo, 
		     int active, char *info);
extern void i_destroy(info_t *i);
extern void i_destroyall();
extern void i_setactive(info_t *i, int active);
extern void i_info(info_t *i, char *info);
extern void i_redrawall();

#endif


