/*                               -*- Mode: C -*- 
 * button.h -- Button include file.
 * 
 * Author          : 
 * Created On      : Tue Apr 20 08:39:34 1999
 * Last Modified By: 
 * Last Modified On: Wed Apr 21 17:01:25 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#ifndef _BUTTON_H
#define _BUTTON_H

struct _button_t;

typedef void (*b_f)(struct _button_t *);

typedef struct _button_t {
  struct _button_t
                *b_next;	/* Next button */
  Display	*b_display;	/* Owner display */
  Window	b_win;		/* Owner window */
  GC		b_gc;		/* Graphical context */
  XFontStruct 	*b_mf;		/* Font information */
  Pixmap	b_stipple;	/* Stipple */
  int		b_x;		/* Relative location of button */
  int		b_y;		/* ditto */
  int		b_width;	/* Width of button */
  int		b_height;	/* Height of button */
  unsigned long	b_fg;		/* Foreground color */
  unsigned long	b_bg;		/* Background color */
  unsigned long	b_hi;		/* High color */
  unsigned long	b_lo;		/* Low color */
  int		b_active;	/* Button active? */
  char		*b_info;	/* Buttton information */
  Pixmap	b_bm;		/* Bitmap to draw */
  int		b_bmw;		/* Bitmap width */
  int		b_bmh;		/* Bitmap height */
  b_f		b_pressf;	/* Action */
  void		*b_data1;	/* Private data 1 */
  void		*b_data2;	/* Private data */
} button_t;

extern button_t *b_new(Display *display, Window win, GC gc, XFontStruct *mf,
		       Pixmap stipple, int x, int y, int width, int height, 
		       unsigned long fg, unsigned long bg, 
		       unsigned long hi, unsigned long lo, 
		       int active, char *info, Pixmap bm, int bmw, int bmh,
		       b_f pressf, void *data1, void *data2);
extern void b_setactive(button_t *b, int active);
extern void b_redrawall();

#endif


