/*                               -*- Mode: C -*- 
 * cwsb.c -- Update the super block.
 * 
 * Author          : 
 * Created On      : Sun Jan 31 12:35:21 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Fri Oct  1 10:17:43 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include "cwif.h"

static char *progname;

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s [-?] device\n", progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  int opt, fd, c, rv;
  cwsb_t sb;
  char *ifile;

  progname = argv[0];
  while ((opt = getopt(argc, argv, "?")) != EOF) {
    switch (opt) {
    case '?':
      usage();
    }
  }
  if (optind != argc - 1) usage();

  ifile = argv[optind++];
  fd    = open(ifile, O_RDONLY);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, ifile, strerror(errno));
    exit(1);
  }

  if (lseek(fd, CW_SBADDR * CW_SSIZE, SEEK_SET) < 0) {
    fprintf(stderr, "%s: Cannot seek on %s: %s\n",
	    progname, ifile, strerror(errno));
    exit(1);
  }

  if ((rv = read(fd, (void *)&sb, sizeof(cwsb_t))) < 0) {
    fprintf(stderr, "%s: Cannot read super block from %s: %s\n",
	    progname, ifile, strerror(errno));
    exit(1);
  }

  if (rv != sizeof(cwsb_t)) {
    fprintf(stderr, 
	    "%s: Partially read super block.  Requested %d, read %d\n",
	    progname, sizeof(cwsb_t), rv);
    exit(1);
  }

  if (sb.sb_magic != CWMAGIC) {
    fprintf(stderr, "%s: Invalid super block on %s (x%08X)\n", progname,
	    ifile, sb.sb_magic);
    exit(1);
  }

  printf("%s MAGIC 0x%08X FDISK %d FTAB %d DID %d BS %d NB %d DBM 0x%08X%08X\n",
	 ifile, sb.sb_magic, sb.sb_fdisk, sb.sb_ftab, sb.sb_did, 
	 sb.sb_blocksz, sb.sb_nblocks, sb.sb_dbmhi, sb.sb_dbmlo);
  (void)close(fd);
  exit(0);
}
