/* Hey Emacs, this is -*-C-*- 
 ******************************************************************************
 * cwrm.c -- Remove a dynamic partition.
 * 
 * Author          : Peter Bosch
 * Created On      : Thu Jun 17 14:27:57 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Thu Jun 17 14:30:01 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 ******************************************************************************
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sched.h>
#include <string.h>
#include <sys/sysmacros.h>

#include "cwif.h"

static char *clockwise = CLOCKWISE;
static char *progname;

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s [-c clockwise] dpnum\n",
	  progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  cwreserve_t reservation;
  int opt, fd, dpnum;

  progname = argv[0];
  while ((opt = getopt(argc, argv, "c:?")) != EOF) {
    switch (opt) {
    case 'c':
      clockwise = optarg;
      break;
    case '?':
      usage();
    }
  }
  if (optind != argc - 1) usage();
  dpnum = strtol(argv[optind++], (char **)NULL, 0);

  fd = open(clockwise, O_RDONLY);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, clockwise, strerror(errno));
    exit(1);
  }

  if (ioctl(fd, CW_RMDP(dpnum), NULL) < 0) {
    fprintf(stderr, "%s: Cannot remove dynamic partition %d: %s\n",
	    progname, dpnum, strerror(errno));
    exit(1);
  }

  (void)close(fd);
  exit(0);
}
