/*                               -*- Mode: C -*- 
 * cwreorganize.c -- Reorganize a dynamic partition.
 * 
 * Author          : 
 * Created On      : Thu Sep 16 07:55:44 1999
 * Last Modified By: 
 * Last Modified On: Thu Sep 16 08:23:48 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <sys/sysmacros.h>

#include "cwif.h"

static char *progname;

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s dynpar offset ldisk daddr\n", progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  char *dpname;
  int opt, fd;
  cwftabentry_t e;
  cwdinode_t *inode;
  cwmove_t m;

  progname = argv[0];
  while ((opt = getopt(argc, argv, "?")) != EOF) {
    switch (opt) {
    case '?':
      usage();
    }
  }
  if (optind != argc - 4) usage();
  dpname     = argv[optind++];
  m.mv_offs  = strtoq(argv[optind++], (char **)NULL, 0);
  m.mv_ldisk = strtol(argv[optind++], (char **)NULL, 0);
  m.mv_daddr = strtol(argv[optind++], (char **)NULL, 0);

  fd = open(dpname, O_RDWR);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, dpname, strerror(errno));
    exit(1);
  }

  if (ioctl(fd, CW_MOVE, &m) < 0) {
    fprintf(stderr, "%s: Cannot move block on dp %s: %s\n",
	    progname, dpname, strerror(errno));
    exit(1);
  }
  
  exit(0);
}
