/*                               -*- Mode: C -*- 
 * cwreserve.c -- Reserve disk space.
 * 
 * Author          : 
 * Created On      : Sun Jan 31 12:35:21 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Mon Oct 11 12:59:49 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */
/*
 * cwnewdp/cwnewdp.c --create new dynamic partition
 *
 * Modified by Saowanee Saewong <ssaewong@andrew.cmu.edu>
 * Last modified date : Wed Oct 19, 2000
 * 
 * -Change name from cwreserve.c to cwnewdp for clarification of
 *  its functionality which is just creating new dynamic partition.
 *  No reservation has been created here.
 */
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sched.h>
#include <string.h>
#include <sys/sysmacros.h>

#include "cwif.h"

static char *clockwise = CLOCKWISE;
static char *progname;
static char *cwdir = "/dev/cw_dir";

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s [-c clockwise] [-C cwdir] dpname nb bpd dbmhi dbmlo base_block\n",
	  progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  cwreserve_t reservation;
  int opt, fd, dpnum, rv;
  char s[128];

  progname = argv[0];
  while ((opt = getopt(argc, argv, "C:c:?")) != EOF) {
    switch (opt) {
    case 'c':
      clockwise = optarg;
      break;
    case 'C':
      cwdir = optarg;
      break;
    case '?':
      usage();
    }
  }
  if (optind != argc - 6) usage();

  reservation.re_dpname[CWMAXDPNAME - 1] = '\0';
  strncpy(reservation.re_dpname, argv[optind++], CWMAXDPNAME - 1);
  reservation.re_nb    = strtol(argv[optind++], (char **)NULL, 0);
  reservation.re_bpd   = strtol(argv[optind++], (char **)NULL, 0);
  reservation.re_dbmhi = strtol(argv[optind++], (char **)NULL, 0);
  reservation.re_dbmlo = strtol(argv[optind++], (char **)NULL, 0);
  reservation.re_bnum  = strtol(argv[optind++], (char **)NULL, 0);

  fd = open(clockwise, O_RDONLY);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, clockwise, strerror(errno));
    exit(1);
  }

  if ((dpnum = ioctl(fd, CW_NEWDP, &reservation)) < 0) {
    fprintf(stderr, "%s: Cannot reserve dynamic partition %s: %s\n",
	    progname, reservation.re_dpname, strerror(errno));
    exit(1);
  }

  (void)close(fd);

  printf("%s: DP %d made\n", progname, dpnum);

  rv = 0;
  snprintf(s, 128, "%s/c_%s", cwdir, reservation.re_dpname);
  printf("%s: Making %s\n", progname, s);
  if (mknod(s, S_IFCHR|0644, MKDEV(CW_C_MAJOR, dpnum)) < 0) {
    fprintf(stderr, "%s: Cannot make %s: %s\n",
	    progname, s, strerror(errno));
    rv = 1;
  }
  
  snprintf(s, 128, "%s/b_%s", cwdir, reservation.re_dpname);
  printf("%s: Making %s\n", progname, s);
  if (mknod(s, S_IFBLK|0644, MKDEV(CW_B_MAJOR, dpnum)) < 0) {
    fprintf(stderr, "%s: Cannot make %s: %s\n",
	    progname, s, strerror(errno));
    rv = 1;
  }

  exit(rv);
}
