/*                               -*- Mode: C -*- 
 * cwdie.c -- Kill the deamons.
 * 
 * Author          : 
 * Created On      : Sun Jan 31 12:35:21 1999
 * Last Modified By: Peter Bosch
 * Last Modified On: Fri Apr  9 11:36:36 1999
 * Status          : Unknown, Use with caution!
 * 
 * Unless other notices are present in any part of this file
 * explicitly claiming copyrights for other people and/or 
 * organizations, the contents of this file is fully copyright 
 * (C) 1999 Peter Bosch, all rights reserved.
 */

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sched.h>
#include <string.h>
#include <sys/sysmacros.h>

#include "cwif.h"

static char *clockwise = CLOCKWISE;
static char *progname;

extern int optind;
extern char *optarg;

static void
usage()
{
  fprintf(stderr, "Usage: %s [-c clockwise]\n",
	  progname);
  exit(1);
}

int
main(int argc, char **argv)
{
  int opt, fd;

  progname = argv[0];
  while ((opt = getopt(argc, argv, "c:?")) != EOF) {
    switch (opt) {
    case 'c':
      clockwise = optarg;
      break;
    case '?':
      usage();
    }
  }
  if (optind != argc) usage();

  fd = open(clockwise, O_RDONLY);
  if (fd < 0) {
    fprintf(stderr, "%s: Cannot open %s: %s\n",
	    progname, clockwise, strerror(errno));
    exit(1);
  }

  if (ioctl(fd, CW_DIE, NULL) < 0) {
    fprintf(stderr, "%s: Cannot kill clockwise deamons: %s\n",
	    progname, strerror(errno));
    exit(1);
  }

  (void)close(fd);
  exit(0);
}
