#include <stdio.h>
#include <rk/rk.h>

void Usage(char *com)
{
    fprintf(stderr, "Usage: %s <resource set id> ...\n", com);
}

int main(int argc, char *argv[])
{
    int i;
    rk_resource_set_t *id;

    if (argc == 1) {
	Usage(argv[0]);
	exit(-1);
    }

    for (i = 1; i < argc; i++) {
	sscanf(argv[i], "%p", &id);
	printf("destroying resource_set id (%p)\n", id);
	if (rk_resource_set_destroy(id) != 0) {
	    fprintf(stderr, "%s: could not destroy rset %p\n",
		    argv[0], id);
	}
    }

    return 0;
}
