#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <rk/rk_error.h>

void Usage(char *com)
{
    fprintf(stderr,
	    "Usage: %s <resource set id in hex> <process id 1> <process id 2> ...\n",
	    com);
}

int main(int argc, char *argv[])
{
    int i;
    void *id;
    unsigned int pid;

    if (argc < 3) {
	Usage(argv[0]);
	exit(-1);
    }

    /* get resource id */
    sscanf(argv[1], "%p", &id);

    /* get process id and attach it */
    for (i = 2; i < argc; i++) {
	sscanf(argv[i], "%u", &pid);
	if (rk_resource_set_attach_process((rk_reserve_t) id, pid) !=
	    RK_SUCCESS) {
	    fprintf(stderr,
		    "Attaching process (with pid %d) to rset %p failed.\n",
		    pid, id);
	}
    }

    return 0;
}
