/* $Author: miyos $	 
 * $Id: socketfilter.h,v 1.1.1.1 2001/04/19 08:43:55 miyos Exp $
 * 
 * socketfilter.h
 *
 */

#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>

#include <net/sock.h>

/* currently only used for IPCs (not for PF_INET) */
struct sockentry {
  struct sockentry *next, *prev;
  struct sock *sock;
  struct sockentry *other;
  pid_t        pid;
  rk_resource_set_t rset;
};


/* access control file for IPC.
 *  TODO: should merge with struct access_control
 *         
 *  This only can represent pid <--> pid communication
 *  Should represent  RPID <---> RPID communication ...in the future.              
 */
struct sock_access_control{
  int version;

  char *srv_progname; 
  char *cli_progname;

  /* at sendmsg and recvmsg, use pid (not ustats..etc) to identify
   * communication for performance.
   */
  pid_t srv_pid;         /* TODO: these should be an array */
  pid_t cli_pid;
};


/* sock->ops->release PF_UNIX, SOCK_STREAM */
int (*us_release)(struct socket *sock, struct socket *peer);
int (*us_sendmsg)(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
int (*us_recvmsg)(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);

extern int my_us_release(struct socket *sock, struct socket *peer);
extern int my_us_sendmsg(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
extern int my_us_recvmsg(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);



/* sock->ops->release PF_INET, SOCK_STREAM */
int (*is_release)(struct socket *sock, struct socket *peer);
int (*is_sendmsg)(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
int (*is_recvmsg)(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);

extern int my_is_release(struct socket *sock, struct socket *peer);
extern int my_is_sendmsg(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
extern int my_is_recvmsg(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);


/* sock->ops->release PF_INET, SOCK_DGRAM */
int (*id_release)(struct socket *sock, struct socket *peer);
int (*id_sendmsg)(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
int (*id_recvmsg)(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);

extern int my_id_release(struct socket *sock, struct socket *peer);
extern int my_id_sendmsg(struct socket *sock, struct msghdr *m, int total_len, struct scm_cookie *scm);
extern int my_id_recvmsg(struct socket *sock, struct msghdr *m, int total_len, int flags, struct scm_cookie *scm);


/*
 * Functions already exported
 */
/*extern __inline__ void sockfd_put(struct socket *sock);*/

extern void fput(struct file *file);

/*
 * Function exported by RK. (linux/kernel/ksym.c)
 */
extern struct socket *sockfd_lookup(int fd, int *err);


/*
 *
 */
extern struct sockentry *sockentry_alloc();
extern inline void sock_enqueue(struct sockentry *sock);
extern struct sockentry *sock_search_queue(struct sock *sock);
extern inline void sock_dequeue(struct sockentry *sock_en);


/*
 * trapper function
 */
asmlinkage int sys_socketcall_trapper(int call, unsigned long *args);


/* misc */
extern int (*set_rcl)(int);
extern int my_set_rcl(int);

extern int       register_sock_acl(char *s_progname, pid_t s_pid, char *c_progname, pid_t c_pid);
extern int       inherit_sock_acl(pid_t s_pid, pid_t c_pid);

#define SOCK_ACL_LEN 5
