/*
 *
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 *
 *
 */
/* 
 * $Author: miyos $	 
 * $Id: queue.c,v 1.1.1.1 2001/04/19 08:43:54 miyos Exp $
 * 
 * queue.c
 * 
 */

#define __NO_VERSION__

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/smp_lock.h>

#include <sys/syscall.h>
#include <linux/sched.h>  
#include <asm/uaccess.h>

#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>

#include <linux/skbuff.h>
#include <linux/ip.h>
#include <net/sock.h>


#include "socketfilter.h"
#include "rclmodule.h"





static struct sockentry *head;

inline void sock_initqueue(){
  head = kmalloc(sizeof(struct sockentry), SLAB_KERNEL);
  head->prev = head->next = NULL;
}


struct sockentry *sockentry_alloc(){
  struct sockentry *sock_en ;
  sock_en = kmalloc(sizeof(struct sockentry), SLAB_KERNEL);
  sock_en->prev = sock_en->next = NULL; 
  return sock_en;
}



inline void sock_enqueue(struct sockentry *sock){
  if(head == NULL)
    sock_initqueue();

  /*head->prev sock head*/

  sock->prev = head->prev;
  sock->next = head;
  head->prev = sock;
  head = sock;
}




struct sockentry *sock_search_queue(struct sock *sock){
  struct sockentry *cur_sock_en;
  
  if(head == NULL)
    sock_initqueue();

  cur_sock_en = head; 
  while(sock != cur_sock_en->sock){
    if(cur_sock_en->next == NULL )
      return NULL;
    cur_sock_en = cur_sock_en->next;
  }
  return cur_sock_en;
}


inline void sock_dequeue(struct sockentry *sock_en){

  if(sock_en == NULL)
    return;
  if( head == NULL )
    return;
  
    sock_en->next->prev = sock_en->prev;
    if(sock_en->prev != NULL)
      sock_en->prev->next = sock_en->next;
    else
      head = sock_en->next;
    kfree(sock_en);
}
