/*
 *
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 *
 */
/* $Author: dionisio $	 
 * $Id: setrcl.c,v 1.1 2001/05/14 18:13:48 dionisio Exp $
 * 
 * rk_manager.c
 * Various resource managers. 
 * 
 */

#define __NO_VERSION__

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/wrapper.h> /*for sleeping and waking processes*/

#include <rk/rk_linux.h>
#include <rk/rk_error.h>
#include <rk/rk.h>

#include "rclmodule.h"
#include "socketfilter.h"

inline void 
set_reserve_params(int version){
  struct resource_control *rcl, *rcl_org;

  cpu_reserve_attr_data_t cpu_attr;
  int i;
  
  if(0 > version || RCLVERSION <= version){
    printk("ERROR: no such verison number\n");
    return;
  }

  rcl     = &rcl_hard_code[version][0];
  rcl_org = rcl_head;
  for(i=1; i < RCL_LEN; i++){
    rcl->rpal                = rcl_org->rpal;
    rcl->rpal->uid           = rcl->uid;
    rcl->rpal->max_processes = MAXPROC;
    rcl->rpal->inherit       = rcl->inherit;
    rcl->rpal->use_reserv    = rcl->use_reserv;
    rcl->rpal->rcl           = rcl;
    if(i != RCL_LEN-1){
      rcl->next                = &rcl_hard_code[version][i+1];
      rcl                      = rcl->next;
      rcl_org                  = rcl_org->next;
    }
  }
  rcl->next = NULL;
  rcl_head  = &rcl_hard_code[version][0];

  rcl = rcl_head;
  while(rcl){
    if(rcl->rpal->rset){
      set_cpuattr(&cpu_attr, rcl);
      if(sys_cpu_reserve_ctl(rcl->rpal->rset, &cpu_attr) != RK_SUCCESS)
	printk("ERROR set_reserve_params: sys_cpu_reserve_ctl\n");
      rcl = rcl->next;
    }
  }
}



int my_set_rcl(int i){
  printk("my_set_rcl: %d\n", i);
  init_manager(i);
  set_reserve_params(i);
  printk("set_reserve_params return\n");
  return 0;
}
