/* $Author: dionisio $	 
 * $Id: rclmodule.h,v 1.1 2001/05/14 18:13:48 dionisio Exp $
 * 
 * rkmodule.h
 */

// all those printks makes everything go slow...  take'm off when
// you don't need'em.
/*#define DEBUG 1 */
/*#define RSDEBUG*/
/*#define FINDEXEC*/

#define  RESERV      0x1 
#define  NORESERV    0x0 
#define  INHERIT     0x1      /* child process inherits parent RCL no matter what */
#define  NOINHERIT   0x0  /* child process does not inherit parent 
			     RCL if matching RCL exist (should be default)*/


#define RCL_LEN     7
#define RCLVERSION  2
#define RCL0        0
#define RCL1        1
#define WILDCARD   -1


#define	CAPACITY_INT(x)		((x)/100)
#define	CAPACITY_FRAC(x)	((x)-(x/100)*100)
#define	INT2CAPACITY(x)		((x)*10000)
#define	CAPACITY2INT(x)		((x)/10000)
#define	PERCENT2CAPACITY(x)	((x)*100)
#define	CAPACITY_OF(c,t)	(INT2CAPACITY(c)/(t))


/// default values
#define MAXPROC 100000                      /* max number of process rpal can spawn off */

extern struct resource_control *rcl_head;   /* link to currently active list of rcls */

extern struct resource_control rcl_hard_code[RCLVERSION][RCL_LEN];

/* data structure */
struct resource_principal{
  int                    uid;
  int                    max_processes;
  char                   inherit;
  struct list_head       uid_list;          /* linked list of proc with same uid? */
  struct list_head       rs_proc_list;      /* process that are currently part of same resource principal */
  struct list_head       rs_proc_list_org;  /* process that are part of same resource principal when created */
  rk_resource_set_t      rset, rsetorg;
  struct resource_control *rcl, *rclorg; 
  char                   use_reserv;      /* uses reserves or not */
};


struct resource_control{
  char                     name[16];
  int                      linenum;           /* id'th line in RCL file... */
  int                      version;
  int                      uid;

  char                     saddrip[18];       /* foreign IP addr */

  char                     *progname;    
  char                     inherit;
  char                     use_reserv;
  struct timespec          ct, tt;
  rk_reserve_param_data_t  p;
  struct resource_control   *next;
  struct resource_principal *rpal; 
};



/* function declaration */
extern inline int                      pre_fork_check(int uid, pid_t pid);
extern inline void                     post_fork_check(int uid, pid_t pid);
extern inline void                     pre_exit_check();
extern inline int                      pre_execve_check(int uid, char *progname);
extern inline int                      register_forked_child(int uid, pid_t pid);

extern inline void                     num_proc(struct list_head *rs_proc_list, int *numproc);
extern inline void                     init_manager();
extern inline struct rs_proc_list*     rs_proc_list_search_pid(struct list_head*, pid_t);
extern inline void                     rs_proc_list_pid(struct rs_proc_list*);
extern inline struct rs_proc_list*     create_new_proc_entry(pid_t, struct task_struct*);
extern struct resource_principal*      search_rpal_from_pid(pid_t);
extern struct resource_principal*      search_rpal_org_from_pid(pid_t);
extern inline struct resource_control* search_rcl(int uid, int pid, char *progname, char *saddr);
extern rk_resource_set_t create_rset_from_rcl(struct resource_control *rcl);
extern void                            cleanup_socket(void);
extern int                             deny_ip(unsigned int addr);
extern int                             accept_ip(unsigned int addr);
extern char                            *in_ntoa(__u32 in);
extern __u32                           in_aton(const char *str);
extern void                            regulate_load(void);

/*
 * pointer to calls that we use.
 */
asmlinkage int                  (*sys_fork_call)(struct pt_regs);
asmlinkage int                  (*sys_vfork_call)(struct pt_regs);
asmlinkage int                  (*sys_clone_call)(struct pt_regs);
asmlinkage int                  (*sys_execve_call)(struct pt_regs);
asmlinkage int                  (*sys_exit_call)(int value);
asmlinkage rk_resource_set_t    (*sys_resource_set_create)(char *);
asmlinkage int                  (*sys_resource_set_attach_process)(rk_resource_set_t rs, pid_t pid);
asmlinkage int                  (*sys_resource_set_detach_process)(rk_resource_set_t rs, pid_t pid);
asmlinkage rk_reserve_t         (*sys_cpu_reserve_create)(rk_resource_set_t rs,
							  cpu_reserve_attr_t atr);
asmlinkage int                  (*sys_cpu_reserve_ctl)(rk_resource_set_t rs, 
						       cpu_reserve_attr_t atr);
asmlinkage int                  (*sys_resource_set_destroy)(rk_resource_set_t rs);
asmlinkage int                  (*getuid_call)();
asmlinkage int                  (*sys_socketcall)(int call, unsigned long *args);


/*
 * trapper functions for syscall filter
 */
extern asmlinkage int sys_fork_trapper(struct pt_regs regs);
extern asmlinkage int sys_vfork_trapper(struct pt_regs regs);
asmlinkage int sys_clone_trapper(struct pt_regs regs);
asmlinkage int sys_execve_trapper(struct pt_regs regs);
asmlinkage int sys_exit_trapper(int value);

///////////////////////////////////////////////////////////////////////////////////
/* 
 *  for debugging purposes...
 *  for original structure see cpu_reserve.c 
 */



/*
 * Internal data structure to keep track of cpu capacity usage
 *	99.99% is represented as 9999
 */
/*
typedef	unsigned long		cpu_capacity_t;
typedef	unsigned long long	cpu_capacity_quad_t;
*/


extern void           *sys_call_table[];
extern rk_reserve_t   cpu_reserve_create(rk_resource_set_t rs,
				       cpu_reserve_attr_t cpu_attr);

extern int            cpu_reserve_ctl(rk_resource_set_t rs, cpu_reserve_attr_t cpu_attr);

extern struct resource_control  *update_rcl(int version, struct resource_control *oldrcl);
extern int                      __rk_resource_set_detach_process(rk_resource_set_t rs, struct task_struct *tsk);
extern inline struct rs_proc_list* remove_proc_from_rpal(struct resource_principal*, int);
extern inline struct rs_proc_list* remove_proc_from_rpal_org(struct resource_principal*, int);
extern inline void              set_cpuattr(cpu_reserve_attr_data_t*, struct resource_control*);

extern int                   sys_socket(int family, int type, int protocol);
extern int                   sys_setsockopt(int fd, int level, int optname, char *optval, int optlen);
