/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*			program developed by Luca Abeni
 *					luca@sssup.it
 *					http://hartik.sssup.it/~luca
 */
/* Modified for FS RSV demo by Saowanee Saewong */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <rk/rk.h>
#include <rk/posix_timers.h>

extern int mpbody(unsigned short int id);
int ac;
char *av[10];

unsigned int times[10000];

unsigned int qos_time(void)
{
    struct timespec t;

    clock_gettime(CLOCK_REALTIME, &t);

    return t.tv_sec * 1000000 + t.tv_nsec / 1000;
}

int main(int argc, char *argv[])
{
    int i;
    int pid1;
    /* int pid2; */

    if (argc < 3) {
       printf("Usage : %s [title] [mpgfile] \n", argv[0]);
       exit(1);
    }    
    ac = argc-1;
    for (i = 0; i < ac; i++) {
	av[i] = argv[i+1];
    }
    pid1 = fork();
    if (pid1 < 0) {
    	perror("Cannot fork task1");
	exit(-1);
    }
    if (pid1 == 0) {
    	mpbody(0);
	exit(0);
    }
    /*
    pid2 = fork();
    if (pid2 < 0) {
    	perror("Cannot fork task1");
	exit(-1);
    }
    if (pid2 == 0) {
    	mpbody(1);
	exit(0);
    }
    */
    //pause();
    wait(NULL);
    exit(0);
}
