/*********************************************************************
 *
 * $Header: /afs/cs.cmu.edu/user/robust/cvsroot//TUTORIAL/SPHINX3/s3trainer/src/libcommon/enum_subset.c,v 1.1.1.1 2002/05/10 16:51:45 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1997 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: enum_subset.c
 * 
 * Description: 
 * 
 * Author: 
 * 
 *********************************************************************/

static char rcsid[] = "@(#)$Id: enum_subset.c,v 1.1.1.1 2002/05/10 16:51:45 robust Exp $";

#include <s3/enum_subset.h>
#include <s3/s3.h>

int
next_subset(uint32 *s,
	    uint32 n,
	    uint32 r)
{
    int i; 
 
    i = r-1; 
 
    for (i = r-1; (i >= 0) && (s[i] == n-r+i); i--); 
 
    if (i < 0) 
        return FALSE; 
 
    s[i]++; 
 
    for (++i; i < r; i++) 
        s[i] = s[i-1] + 1; 
 
    return TRUE;
}


/*
 * Log record.  Maintained by RCS.
 *
 * $Log: enum_subset.c,v $
 * Revision 1.1.1.1  2002/05/10 16:51:45  robust
 * Initial port of tutorial into cvs.
 *
 * Revision 1.1  97/07/16  11:36:22  eht
 * Initial revision
 * 
 *
 */
