/*********************************************************************
 *
 * $Header: /afs/cs.cmu.edu/user/robust/cvsroot//TUTORIAL/SPHINX3/s3trainer/src/cp_parm/cmd_ln_defn.h,v 1.1.1.1 2002/05/10 16:51:44 robust Exp $
 *
 * CMU ARPA Speech Project
 *
 * Copyright (c) 1998 Carnegie Mellon University.
 * All rights reserved.
 *
 *********************************************************************
 *
 * File: cmd_ln_defn.h
 * 
 * Description: 
 * 	Command line argument definition
 *
 * Author: 
 *      Eric Thayer (eht@cs.cmu.edu)
 *********************************************************************/

#ifndef CMD_LN_DEFN_H
    static arg_def_t defn[] = {
	{ "-cpopsfn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Copy operation file name" },

	{ "-imixwfn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Input mixing weight file" },
	{ "-omixwfn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Output mixing weight file" },
	{ "-nmixwout",
	  CMD_LN_INT32,
	  CMD_LN_NO_DEFAULT,
	  "# of mixing weight arrays in the output file" },
	  
	{ "-itmatfn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Input transition matrix file" },
	{ "-otmatfn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Output transition matrix file" },
	{ "-ntmatout",
	  CMD_LN_INT32,
	  CMD_LN_NO_DEFAULT,
	  "# of transition matrices in the output file" },

	{ "-igaufn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Input Gaussian density parameter file" },
	{ "-ogaufn",
	  CMD_LN_STRING,
	  CMD_LN_NO_DEFAULT,
	  "Output Gaussian density parameter file" },
	{ "-ncbout",
	  CMD_LN_INT32,
	  CMD_LN_NO_DEFAULT,
	  "# of codebooks in the output file" },

	{ "-feat",
	  CMD_LN_STRING,
	  "c[1..L-1]d[1..L-1]c[0]d[0]dd[0]dd[1..L-1]",
	  "Feature set to use" },
	  
    { NULL, CMD_LN_UNDEF, CMD_LN_NO_DEFAULT, NULL }
    };
#define CMD_LN_DEFN_H

#endif /* CMD_LN_DEFN_H */ 

/*
 * Log record.  Maintained by RCS.
 *
 * $Log: cmd_ln_defn.h,v $
 * Revision 1.1.1.1  2002/05/10 16:51:44  robust
 * Initial port of tutorial into cvs.
 *
 *
 */
