#!/bin/csh -f

source ../c_scripts/variables.def

if ($#argv < 2) then
    echo "Usage: $0 part npart [startskip]"
    exit
endif

set PGM = ./s3decode-anytopo.${mach}



set mdef      = $base_dir/model_architecture/${exptname}.ci.mdef
set modeldir  = $base_dir/model_parameters/${exptname}.ci_continuous
set outname   = ${exptname}.cimodels
#set outlatdir = /dev/null
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set ACMODDIR  = $modeldir

set echo
limit coredumpsize 0
unlimit datasize



onintr docleanup

set part  = $1
set npart = $2
if ($#argv > 2) then
  set startskip = $4:q
else
  set startskip = 0
endif

set nlines = `wc $ctlfn | awk '{print $1}'`
set ctloffset ctlcount
@ ctloffset = $startskip + ( ( $nlines * ( $part - 1 ) ) / $npart )
@ ctlcount = ( ( $nlines * $part ) / $npart ) - $ctloffset
echo "Doing $ctlcount segments starting at number $ctloffset"

set result = ./result;

if ( $startskip == 0 ) then
  set logfile = $result/${outname}-${part}.log
  set matchfile = $result/${outname}-${part}.match
else
  set logfile = $result/${outname}-${part}-${startskip}.log
  set matchfile = $result/${outname}-${part}-${startskip}.match
endif

if (! -d $result) then
  mkdir -p $result
  echo "WARNING: $result does not exist. Creating it." >> $logfile
  echo "WARNING: $result does not exist. Creating it."
endif

if (! -d $cepdir) then
  echo "ERROR: $cepdir does not exist" >> $logfile
  echo "ERROR: $cepdir does not exist"
  exit 1
endif

if (! -d $ACMODDIR) then
  echo "ERROR: $ACMODDIR does not exist" >> $logfile
  echo "ERROR: $ACMODDIR does not exist"
  exit 1
endif

if (! -f $lmfile) then
  echo "ERROR: $lmfile does not exist" >> $logfile
  echo "ERROR: $lmfile does not exist"
  exit 1
endif

if (! -f $ctlfn) then
  echo "ERROR: $ctlfn does not exist" >> $logfile
  echo "ERROR: $ctlfn does not exist"
  exit 1
endif

### now actually start  (this will clobber the previous logfile)
$PGM \
        -logbase    1.0001 \
        -bestpath   1 \
        -mdeffn     $mdef \
	-senmgaufn  .cont. \
        -meanfn     $ACMODDIR/means \
        -varfn      $ACMODDIR/variances \
        -mixwfn     $ACMODDIR/mixture_weights \
        -tmatfn     $ACMODDIR/transition_matrices \
        -langwt     $langwt  \
        -feat       $feature \
        -topn       32 \
        -beam       1e-80 \
        -nwbeam     1e-40 \
        -dictfn     $dictfn \
        -fdictfn    $fdictfn \
        -lmfn       $lmfile \
        -inspen     0.2 \
        -ctlfn      $ctlfn \
	-ctloffset  $ctloffset \
	-ctlcount   $ctlcount \
        -cepdir     $cepdir \
	-cepext     mfc \
        -bptblsize  400000 \
#        -matchsegfn    $matchfile \
        -matchfn    $matchfile \
#	-outlatdir  $outlatdir \
        -agc        none \
	-varnorm    no \
         -cmn     current \
>& $logfile

docleanup:
set savedstatus=$status:q

onintr
echo '================' >> $logfile
echo "exited with status $savedstatus" >> $logfile

exit $savedstatus
