#!/bin/csh -f

# This is a script file used by the tutorial
# for setting up a new experiment
# usage: create_newexpt.csh <new expt name>

if ($#argv != 1) then
   echo "usage: $0 <new expt name>"
   exit 1
endif

set newexptname=$1

# copy model files to user directory
if (-e SPHINX3) then
else
    echo "ERROR: expecting SPHINX3 to be in the current directory"
    echo "please change into the right diretory and try again"
    exit 1
endif

mkdir -p $newexptname

# copy experiment scripts
rsync -aC /afs/cs.cmu.edu/user/robust/project/TUTORIAL/SPHINX3/c_scripts $newexptname/
rsync -aC /afs/cs.cmu.edu/user/robust/project/TUTORIAL/SPHINX3/decoding $newexptname/
rsync -aC /afs/cs.cmu.edu/user/robust/project/TUTORIAL/SPHINX3/lists $newexptname/

set x = `hostname -s`

ln -s /net/$x/$cwd/SPHINX3/s3trainer $newexptname/s3trainer
ln -s /net/$x/$cwd/SPHINX3/util $newexptname/util

sed "s/SPHINX3/$newexptname/g;s+<base_dir>+`pwd`/$newexptname+g" SPHINX3/c_scripts/variables.def > $newexptname/c_scripts/variables.def 


# cepstra
ln -s /net/$x/$cwd/SPHINX3/feature_files ${newexptname}/feature_files 

echo "A new directory called ./$newexptname has been created with all the"
echo "files needed for a new experiment.  Run the new experiment in that directory."









