#! /bin/csh -f

source ./variables.def

if ($#argv != 1) then
    echo "USAGE: $0 <wavefile_list>"
    exit 0
endif

set infile = $1

foreach file (`cat $infile`)  
    set x = `echo $file | gawk -F"/" '1==1{printf("%s",$(NF-1));}'`    
    set outdir = ../../SPHINX3/feature_files/$x
    if ( ! -e $outdir ) then
	mkdir -p $outdir
	echo "Working on $outdir"
    endif
    
    set x = `echo $file | gawk -F"/" '1==1{print $NF;}'`
    set y = $x:r
    set outfile = $outdir/$y.mfc
    
    set logfile = /dev/null

    if ( -e $file ) then
    $bindir/wave2feat \
	-i $file   \
	-o $outfile  \
	-srate 16000 \
	-lowerf 130  \
	-upperf 6800 \
	-dither      \
	>> $logfile
    else 
	echo $file not found >> $logfile
    endif
end

exit 0

