#! /usr/local/bin/tcsh -f

source ../variables.def

#*************************************************************************
# This script runs the prunetree and tiestate scripts 
#*************************************************************************

set scriptdir = $base_dir/c_scripts/04.tiestate
set qmgrdir = $base_dir/qmanager
/bin/rm -f $qmgrdir/*.err
/bin/rm -f $qmgrdir/*.out
/bin/rm -f $qmgrdir/*
set logdir = $base_dir/logdir/04.tiestate
if ( ! -e $logdir ) mkdir -p $logdir
/bin/rm -f $logdir/*

#set killfile = $qmgrdir/04.tiestate.killfile

#$n_tied_states obtained from variables.def

set errfn = $qmgrdir/prunetree.$n_tied_states.err 
set outfn = $qmgrdir/prunetree.$n_tied_states.out
set jobname = prunetree.$n_tied_states
#set prunejid = `bsub -J $jobname -e $errfn -o $outfn $scriptdir/prunetree.csh $n_tied_states | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#echo "prunetree = $prunejid submitted"
#echo "bkill $prunejid" >> $killfile
$scriptdir/prunetree.csh $n_tied_states >&! $outfn

set errfn = $qmgrdir/tiestate.$n_tied_states.err
set outfn = $qmgrdir/tiestate.$n_tied_states.out
set jobname = tiestate.$n_tied_states
#set tiejid = `bsub -J $jobname -w $prunejid -e $errfn -o $outfn $scriptdir/tiestate.csh $n_tied_states | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#echo "Tiestate = $tiejid submitted"
#echo "bkill $tiejid" >> $killfile
$scriptdir/tiestate.csh $n_tied_states >&! $outfn

#chmod +x $killfile

exit 0
