#! /usr/local/bin/tcsh -f

source ../variables.def

#*************************************************************************
# This script runs the build_tree script for each state of each basephone
#*************************************************************************

set scriptdir = $base_dir/c_scripts/03.buildtrees
set qmgrdir = $base_dir/qmanager
set logdir = $base_dir/logdir/03.buildtrees
if ( ! -e $logdir ) mkdir -p $logdir
/bin/rm -rf $logdir
/bin/rm -rf $qmgrdir
mkdir -p $logdir
mkdir -p $qmgrdir
#set killfile = $qmgrdir/03.buildtrees.killfile
#touch $killfile

#$phonefile obtained from variables.def
#$statesperhmm obtained from variables.def

set errfile = $qmgrdir/make_quest.err
set outfile = $qmgrdir/make_quest.out
#set questjid = `bsub -q $qtype -r -e $errfile -o $outfile $scriptdir/make_questions.csh | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
$scriptdir/make_questions.csh >&! $outfile

#echo "bkill $questjid" >> $killfile
#echo "Question Maker $questjid submitted"

foreach phone (`cat $phonefile`)
    set state = 0
    while ( $state < $statesperhmm )
        set errfile = $qmgrdir/buildtree.$phone.$state.err
        set outfile = $qmgrdir/buildtree.$phone.$state.out
#        set bldjid = `bsub -q $qtype -m "$M" -w $questjid -r -R "type==any" -e $errfile -o $outfile $scriptdir/build_tree.csh $phone $state | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#	echo "Phone = $phone, State = $state - $bldjid submitted"
#        echo "bkill $bldjid" >> $killfile
        $scriptdir/build_tree.csh $phone $state >&! $outfile
	echo "Phone = $phone, State = $state - completed"
    @   state = $state + 1
    end
end

#chmod +x $killfile

exit 0
