#!/bin/csh -f

source ../variables.def

#***************************************************************************
# This script launches all the ci - continuous training jobs in the proper
# order. First it cleans up the directories, then launches the 
# flat initialization, and the baum-welch and norm jobs for the required
# number of iterations. Within each iteration it launches as many baumwelch
# jobs as the number of parts we wish to split the training into.
#***************************************************************************

if ($#argv > 1) then
    echo "USAGE: $0 <iteration number (def 1)>"
    exit 0
endif

if ($#argv == 0) then
    echo "USAGE: $0 <iteration number (def 1)>"
    echo "Setting iter value to 1"
    echo -n "Continue? (y/n) "
    set ans = $<
    if ($ans != "y") exit 0
    set iter = 1
else
    set iter = $1
endif
set scriptdir = $base_dir/c_scripts/01.ci-chmm
set qmgrdir   = $base_dir/qmanager
if ( ! -e $qmgrdir ) mkdir -p $qmgrdir
set logdir = $base_dir/logdir/01.ci_chmm
if ( ! -e $logdir ) mkdir -p $logdir        
set bwaccumdir = $base_dir/bwaccumdir
set modeldir  = $base_dir/model_parameters
if ( ! -e $bwaccumdir ) mkdir -p $bwaccumdir
if ( ! -e $modeldir ) mkdir -p $modeldir


echo "Cleaning up accumulator directories..."
/bin/rm  -f $bwaccumdir/${exptname}_buff_?/* $bwaccumdir/${exptname}_buff_??/*

if ($iter == 1) then
    echo "Cleaning up log directories..."
    /bin/rm -f $logdir/*
    echo "Cleaning up qmanager directories..."
    /bin/rm -f $qmgrdir/*.err
    /bin/rm -f $qmgrdir/*.out
    /bin/rm -f $qmgrdir/*
    echo "Cleaning up model directories.."
    /bin/rm -f $modeldir/${exptname}.ci_continuous/*
endif

if ($iter == 1) then
    # For the first iteration Flat initialize models.
    # To start off queue trap job id
    set errfn = $qmgrdir/$exptname.initialize_ci.err
    set outfn = $qmgrdir/$exptname.initialize_ci.out
    set normjob_name = $exptname.initialize.ci_dhmm
#    set normjob_id = `bsub -R "type==ALPHA" -q priority  -r -J $normjob_name -e $errfn -o $outfn $scriptdir/flat_initialize.csh | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#    echo "$normjob_name = $normjob_id submitted"
    $scriptdir/flat_initialize.csh >&! $outfn

    set partid = 1
    set errfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.err
    set outfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.out

    # Submit job and store id
    set bwjob_name = $exptname.$iter.bw.ci.$partid
#    set bwjob_id = `bsub -m "$M" -q $qtype -R "type==any" -r -J $bwjob_name -w $normjob_id -e $errfn -o $outfn $scriptdir/baum_welch.csh $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#    echo "$bwjob_name = $bwjob_id submitted"
#    set bwjids = $bwjob_id
    $scriptdir/baum_welch.csh $iter $partid $npart >&! $outfn

    @   partid = $partid + 1
    while ($partid <= $npart)
	set errfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.err
	set outfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.out

        # Submit job and store id
        set bwjob_name = $exptname.$iter.bw.ci.$partid
#        set bwjob_id = `bsub -m "$M" -q $qtype -R "type==any" -r -J $bwjob_name -w $normjob_id -e $errfn -o $outfn $scriptdir/baum_welch.csh $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#        echo "$bwjob_name = $bwjob_id submitted"
#	set bwjids = `echo "$bwjids && $bwjob_id"`
        $scriptdir/baum_welch.csh $iter $partid $npart >&! $outfn

@	partid = $partid + 1
    end

    set errfn = $qmgrdir/$exptname.norm.ci.$iter.err
    set outfn = $qmgrdir/$exptname.norm.ci.$iter.out

    # Run norm only if all the bw jobs have run
    set normjob_name = $exptname.$iter.ci.norm
    
#    set normjob_id = `bsub -m "$M" -q priority -r -R "type==ALPHA" -J $normjob_name -w "${bwjids}" -e $errfn -o $outfn $scriptdir/norm_and_launchbw.csh $iter | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#    echo "$normjob_name = $normjob_id submitted"
    $scriptdir/norm_and_launchbw.csh $iter >&! $outfn

    exit 0
endif

set partid = 1
set errfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.err
set outfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.out

# Submit job and store id
set bwjob_name = $exptname.$iter.bw.ci.$partid
#set bwjob_id = `bsub -m "$M" -q $qtype -R "type==any" -r -J $bwjob_name -e $errfn -o $outfn $scriptdir/baum_welch.csh $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#echo "$bwjob_name = $bwjob_id submitted"

#set bwjids = $bwjob_id
$scriptdir/baum_welch.csh $iter $partid $npart >&! $outfn

@   partid = $partid + 1
while ($partid <= $npart)
    set errfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.err
    set outfn = $qmgrdir/$exptname.bw.ci.$iter.$partid.out

    # Submit job and store id
    set bwjob_name = $exptname.$iter.bw.ci.$partid
#    set bwjob_id = `bsub -m "$M" -q $qtype -R "type==any" -r -J $bwjob_name -e $errfn -o $outfn $scriptdir/baum_welch.csh $iter $partid $npart| awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#    echo "$bwjob_name = $bwjob_id submitted"
#    set bwjids = `echo "$bwjids && $bwjob_id"`
    $scriptdir/baum_welch.csh $iter $partid $npart >&! $outfn
@    partid = $partid + 1
end

set errfn = $qmgrdir/$exptname.norm.ci.$iter.err
set outfn = $qmgrdir/$exptname.norm.ci.$iter.out

# Run norm only if all the bw jobs have run
set normjob_name = $exptname.$iter.ci.norm
    
#set normjob_id = `bsub -m "$M" -q priority -R "type==ALPHA" -r -J $normjob_name -w "${bwjids}" -e $errfn -o $outfn $scriptdir/norm_and_launchbw.csh $iter | awk '{print $2}' | sed -e 's+<++g' -e 's+>++g'`
#echo "$normjob_name = $normjob_id submitted"
$scriptdir/norm_and_launchbw.csh $iter >&! $outfn &

exit 0
