#!/bin/csh -f

source ../variables.def
unlimit
limit core 0k
#*******************************************************************
# This script gathers the buffers generated by all parts of the baum-welch
# computes the model parameters
#*******************************************************************

if ($#argv != 1) then
   echo "usage: $0 <iter>"
   exit 1
endif

set iter = $1

set scriptdir = $base_dir/c_scripts/01.ci-chmm
cd  $scriptdir

# cover up to 100 different buffer directories....
set buffer_dirs = ($base_dir/bwaccumdir/${exptname}_buff_? $base_dir/bwaccumdir/${exptname}_buff_??)

if ($type == ".semi.") then
   set modeltype = semi
else
   set modeltype = continuous
endif

set hmm_dir           = $base_dir/model_parameters/${exptname}.ci_${modeltype}
if ( ! -e $hmm_dir ) mkdir -p $hmm_dir

#new models to be produced after normalization
set mixwfn         = $hmm_dir/mixture_weights
set tmatfn         = $hmm_dir/transition_matrices
set meanfn         = $hmm_dir/means
set varfn          = $hmm_dir/variances


set logdir = $base_dir/logdir/01.ci_chmm
if ( ! -e $logdir ) mkdir -p $logdir        
set log            = $logdir/${exptname}.$iter.norm.log

set NORM   = $bindir/norm.mop64

$NORM \
	-accumdir   $buffer_dirs \
	-mixwfn     $mixwfn \
	-tmatfn     $tmatfn \
	-meanfn     $meanfn \
	-varfn      $varfn \
	>&! $log
date >> $log

exit 0
